/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.gc;

import com.swiftmq.tools.collection.RingBuffer;
import com.swiftmq.tools.gc.Recyclable;

public abstract class Recycler {
    static final int DEFAULT_SIZE = 128;
    RingBuffer freeList = null;
    Recyclable[] useList = null;
    int maxSize = -1;
    int nUsed = 0;

    public Recycler(int maxSize) {
        this.maxSize = maxSize;
        this.freeList = new RingBuffer(128);
        this.useList = new Recyclable[128];
    }

    public Recycler() {
        this(-1);
    }

    protected abstract Recyclable createRecyclable();

    private Recyclable getFirstUsed(Recyclable[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            Recyclable r = list[i];
            list[i] = null;
            return r;
        }
        return null;
    }

    private int setFirstFree(Recyclable[] list, Recyclable recyclable) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != null) continue;
            list[i] = recyclable;
            return i;
        }
        return -1;
    }

    public Recyclable checkOut() {
        Recyclable recyclable = null;
        if (this.freeList.getSize() > 0) {
            recyclable = (Recyclable)this.freeList.remove();
        } else {
            recyclable = this.createRecyclable();
            if (this.nUsed == this.useList.length) {
                Recyclable[] r = new Recyclable[this.useList.length + 128];
                System.arraycopy(this.useList, 0, r, 0, this.useList.length);
                this.useList = r;
            }
        }
        recyclable.setRecycleIndex(this.setFirstFree(this.useList, recyclable));
        ++this.nUsed;
        return recyclable;
    }

    public void checkIn(Recyclable recyclable) {
        this.useList[recyclable.getRecycleIndex()] = null;
        --this.nUsed;
        recyclable.setRecycleIndex(-1);
        if (this.maxSize == -1 || this.freeList.getSize() < this.maxSize) {
            recyclable.reset();
            this.freeList.add(recyclable);
        }
    }

    public Recyclable get(int index) {
        return this.useList[index];
    }

    public Recyclable[] getUseList() {
        return this.useList;
    }

    public void clear() {
        this.freeList.clear();
        for (int i = 0; i < this.useList.length; ++i) {
            this.useList[i] = null;
        }
        this.nUsed = 0;
    }
}

