/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.prop;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class EventProperties
extends Properties {
    Hashtable propListeners = new Hashtable();
    PropertyChangeListener generalListener = null;

    public EventProperties(Properties defaults) {
        super(defaults);
    }

    public EventProperties() {
        this((Properties)null);
    }

    @Override
    public Object setProperty(String key, String value) {
        String oldValue = this.getProperty(key);
        Object obj = super.setProperty(key, value);
        this.firePropertyChange(key, oldValue, value);
        return obj;
    }

    @Override
    public Object remove(Object key) {
        String skey = (String)key;
        String oldValue = this.getProperty(skey);
        Object obj = super.remove(skey);
        this.firePropertyChange(skey, oldValue, null);
        return obj;
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        Properties p = new Properties();
        p.load(inStream);
        Enumeration<?> newProps = p.propertyNames();
        while (newProps.hasMoreElements()) {
            String key = (String)newProps.nextElement();
            String newValue = p.getProperty(key);
            this.setProperty(key, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String key, PropertyChangeListener listener) {
        Hashtable hashtable = this.propListeners;
        synchronized (hashtable) {
            if (key == null) {
                this.generalListener = listener;
            } else {
                Vector<PropertyChangeListener> vec = (Vector<PropertyChangeListener>)this.propListeners.get(key);
                if (vec != null) {
                    vec.addElement(listener);
                } else {
                    vec = new Vector<PropertyChangeListener>();
                    vec.addElement(listener);
                    this.propListeners.put(key, vec);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String key, PropertyChangeListener listener) {
        Hashtable hashtable = this.propListeners;
        synchronized (hashtable) {
            if (key == null) {
                this.generalListener = null;
            } else {
                Vector vec = (Vector)this.propListeners.get(key);
                if (vec != null) {
                    vec.removeElement(listener);
                    if (vec.size() == 0) {
                        this.propListeners.remove(key);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String key, String oldValue, String newValue) {
        if (oldValue == null && newValue != null || oldValue != null && newValue == null || oldValue != null && newValue != null && !oldValue.equals(newValue)) {
            Hashtable hashtable = this.propListeners;
            synchronized (hashtable) {
                Vector vec = (Vector)this.propListeners.get(key);
                if (vec != null) {
                    PropertyChangeEvent evt = new PropertyChangeEvent(this, key, oldValue, newValue);
                    for (int i = 0; i < vec.size(); ++i) {
                        ((PropertyChangeListener)vec.elementAt(i)).propertyChange(evt);
                    }
                }
                if (this.generalListener != null) {
                    this.generalListener.propertyChange(new PropertyChangeEvent(this, key, oldValue, newValue));
                }
            }
        }
    }
}

