/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.queue;

public class FIFOQueue {
    private Object semEnqueue = new Object();
    private Object semDequeue = new Object();
    private Object[] data;
    private int first = 0;
    private volatile int size = 0;
    private int bucketSize = 32;
    private volatile boolean shouldStop = false;

    public FIFOQueue(int bucketSize) {
        this.data = new Object[bucketSize];
        this.bucketSize = bucketSize;
    }

    public FIFOQueue() {
        this(32);
    }

    public int getActEntries() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStopped() {
        this.shouldStop = true;
        Object object = this.semEnqueue;
        synchronized (object) {
            this.semEnqueue.notifyAll();
        }
        object = this.semDequeue;
        synchronized (object) {
            this.semDequeue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object obj) {
        if (this.shouldStop) {
            return;
        }
        Object object = this.semEnqueue;
        synchronized (object) {
            if (!this.shouldStop) {
                Object object2 = this.semDequeue;
                synchronized (object2) {
                    if (this.size == this.data.length) {
                        int newSize = this.data.length + this.bucketSize;
                        Object[] newData = new Object[newSize];
                        int n = this.data.length - this.first;
                        System.arraycopy(this.data, this.first, newData, 0, n);
                        if (this.first != 0) {
                            System.arraycopy(this.data, 0, newData, n, this.first);
                        }
                        this.data = newData;
                        this.first = 0;
                    }
                    this.data[(this.first + this.size) % this.data.length] = obj;
                    ++this.size;
                    this.semDequeue.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue() {
        Object obj = null;
        Object object = this.semDequeue;
        synchronized (object) {
            while (this.size == 0 && !this.shouldStop) {
                try {
                    this.semDequeue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.shouldStop) {
                obj = this.data[this.first];
                this.data[this.first] = null;
                ++this.first;
                --this.size;
                if (this.first == this.data.length) {
                    this.first = 0;
                }
            } else {
                this.data = null;
            }
        }
        object = this.semEnqueue;
        synchronized (object) {
            this.semEnqueue.notify();
        }
        return obj;
    }
}

