/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.queue;

public abstract class SimpleQueue
extends Thread {
    private Object semEnqueue = new Object();
    private Object semDequeue = new Object();
    private Object[] data;
    private int first;
    private volatile int size;
    private int maxEntries = 10;
    private boolean shouldStop = false;

    public SimpleQueue(int max) {
        this.data = new Object[max];
        this.maxEntries = max;
        this.start();
    }

    public SimpleQueue() {
        this(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxEntries(int m) {
        if (m > this.maxEntries) {
            Object object = this.semEnqueue;
            synchronized (object) {
                Object[] newData = new Object[m];
                System.arraycopy(this.data, 0, newData, 0, this.maxEntries);
                this.data = newData;
                this.maxEntries = m;
            }
        }
    }

    public int getActEntries() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStopped() {
        this.shouldStop = true;
        Object object = this.semEnqueue;
        synchronized (object) {
            this.semEnqueue.notifyAll();
        }
        object = this.semDequeue;
        synchronized (object) {
            this.semDequeue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(Object obj) {
        if (this.shouldStop) {
            return;
        }
        Object object = this.semEnqueue;
        synchronized (object) {
            while (this.size == this.data.length && !this.shouldStop) {
                try {
                    this.semEnqueue.wait();
                }
                catch (Exception exception) {}
            }
            if (!this.shouldStop) {
                Object object2 = this.semDequeue;
                synchronized (object2) {
                    this.data[(this.first + this.size) % this.data.length] = obj;
                    ++this.size;
                    this.semDequeue.notify();
                }
            }
        }
    }

    public abstract boolean processObject(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean ok = true;
        while (ok) {
            Object obj = null;
            Object object = this.semDequeue;
            synchronized (object) {
                while (this.size == 0 && !this.shouldStop) {
                    try {
                        this.semDequeue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.shouldStop) {
                    obj = this.data[this.first];
                    this.data[this.first] = null;
                    ++this.first;
                    --this.size;
                    if (this.first == this.data.length) {
                        this.first = 0;
                    }
                } else {
                    this.data = null;
                }
            }
            object = this.semEnqueue;
            synchronized (object) {
                this.semEnqueue.notify();
            }
            ok = !this.shouldStop ? this.processObject(obj) : false;
            Object var2_2 = null;
        }
    }
}

