/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.queue;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class SingleProcessorQueue {
    private Object[] elements;
    private int first = 0;
    private int size = 0;
    private int bucketSize = 32;
    private int bulkSize = 1;
    private boolean closed = false;
    private boolean started = false;
    private boolean processorActive = false;
    private Object[] bulkWrapper = null;
    private Object[] passDirectWrapper = new Object[1];
    private Object[] nullArray = null;
    private Lock lock = new ReentrantLock();

    public SingleProcessorQueue(int bucketSize, int bulkSize) {
        this.elements = new Object[bucketSize];
        this.bucketSize = bucketSize;
        this.bulkSize = bulkSize;
        this.bulkWrapper = new Object[bulkSize == -1 ? bucketSize : bulkSize];
        this.nullArray = new Object[bulkSize == -1 ? bucketSize : bulkSize];
    }

    public SingleProcessorQueue(int bulkSize) {
        this(32, bulkSize);
    }

    public SingleProcessorQueue() {
        this(32, 1);
    }

    public int getSize() {
        this.lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isClosed() {
        this.lock.lock();
        try {
            boolean bl = this.closed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isStarted() {
        this.lock.lock();
        try {
            boolean bl = this.started;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doEnqueue(Object obj) {
        if (this.size == this.elements.length) {
            int newSize = this.elements.length + this.bucketSize;
            Object[] newElements = new Object[newSize];
            int n = this.elements.length - this.first;
            System.arraycopy(this.elements, this.first, newElements, 0, n);
            if (this.first != 0) {
                System.arraycopy(this.elements, 0, newElements, n, this.first);
            }
            this.elements = newElements;
            this.first = 0;
        }
        this.elements[(this.first + this.size) % this.elements.length] = obj;
        ++this.size;
    }

    private void clearBulk() {
        System.arraycopy(this.nullArray, 0, this.bulkWrapper, 0, this.bulkWrapper.length);
    }

    public void enqueue(Object obj) {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.doEnqueue(obj);
            if (!this.processorActive && this.started) {
                this.startProcessor();
                this.processorActive = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dequeue() {
        int n = 0;
        this.lock.lock();
        try {
            if (this.closed || !this.started || this.size == 0) {
                this.processorActive = false;
                boolean bl = false;
                return bl;
            }
            n = this.getBulk();
        }
        finally {
            this.lock.unlock();
        }
        this.process(this.bulkWrapper, n);
        this.clearBulk();
        boolean rc = true;
        this.lock.lock();
        try {
            if (this.size == 0) {
                this.processorActive = false;
            }
            rc = this.size > 0;
        }
        finally {
            this.lock.unlock();
        }
        return rc;
    }

    private int getBulk() {
        int n = 0;
        int bl = Math.min(this.size, this.bulkWrapper.length);
        for (int i = 0; i < bl && this.size > 0; ++i) {
            this.bulkWrapper[n++] = this.elements[this.first];
            this.elements[this.first] = null;
            ++this.first;
            --this.size;
            if (this.first != this.elements.length) continue;
            this.first = 0;
        }
        return n;
    }

    protected abstract void startProcessor();

    protected abstract void process(Object[] var1, int var2);

    public void startQueue() {
        this.lock.lock();
        try {
            this.closed = false;
            this.started = true;
            if (!this.processorActive && this.size > 0) {
                this.startProcessor();
                this.processorActive = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stopQueue() {
        this.lock.lock();
        try {
            this.started = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean validateClearElement(Object obj) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            int n = 0;
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i] == null) continue;
                if (this.validateClearElement(this.elements[i])) {
                    this.elements[i] = null;
                    continue;
                }
                ++n;
            }
            if (n > 0) {
                Object[] o = new Object[this.elements.length];
                int m = 0;
                for (int i = 0; i < this.elements.length; ++i) {
                    Object obj;
                    if ((obj = this.elements[this.first++]) != null) {
                        o[m++] = obj;
                    }
                    if (this.first != this.elements.length) continue;
                    this.first = 0;
                }
                this.elements = o;
                this.size = m;
                this.first = 0;
            } else {
                this.size = 0;
                this.first = 0;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        this.lock.lock();
        try {
            this.closed = true;
            this.elements = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

