/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.requestreply;

import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.requestreply.ReplyHandler;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Reply
implements Dumpable,
Serializable {
    boolean ok = false;
    Exception exception = null;
    boolean timeout = false;
    int requestNumber = 0;
    transient ReplyHandler replyHandler = null;

    @Override
    public int getDumpId() {
        return 0;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        out.writeBoolean(this.ok);
        if (this.exception == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            DataByteArrayOutputStream dos = new DataByteArrayOutputStream(256);
            new ObjectOutputStream(dos).writeObject(this.exception);
            out.writeInt(dos.getCount());
            out.write(dos.getBuffer(), 0, dos.getCount());
        }
        out.writeBoolean(this.timeout);
        out.writeInt(this.requestNumber);
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.ok = in.readBoolean();
        byte set = in.readByte();
        if (set == 0) {
            this.exception = null;
        } else {
            try {
                byte[] b = new byte[in.readInt()];
                in.readFully(b);
                this.exception = (Exception)new ObjectInputStream(new DataByteArrayInputStream(b)).readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.timeout = in.readBoolean();
        this.requestNumber = in.readInt();
    }

    int getRequestNumber() {
        return this.requestNumber;
    }

    void setRequestNumber(int requestNumber) {
        this.requestNumber = requestNumber;
    }

    void setReplyHandler(ReplyHandler replyHandler) {
        this.replyHandler = replyHandler;
    }

    public boolean isOk() {
        return this.ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public void setTimeout(boolean timeout) {
        this.timeout = timeout;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void send() {
        this.replyHandler.performReply(this);
    }

    public String toString() {
        return "[Reply, ok=" + this.ok + " exception=" + this.exception + " requestNumber=" + this.requestNumber + " timeout=" + this.timeout + " ]";
    }
}

