/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.requestreply;

import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class ReplyRequest
extends Request {
    boolean ok = false;
    Exception exception = null;

    public ReplyRequest(int dispatchId, boolean replyRequired) {
        super(dispatchId, replyRequired);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        out.writeBoolean(this.ok);
        if (this.exception == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            DataByteArrayOutputStream dos = new DataByteArrayOutputStream(256);
            new ObjectOutputStream(dos).writeObject(this.exception);
            out.writeInt(dos.getCount());
            out.write(dos.getBuffer(), 0, dos.getCount());
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.ok = in.readBoolean();
        byte set = in.readByte();
        if (set == 0) {
            this.exception = null;
        } else {
            try {
                byte[] b = new byte[in.readInt()];
                in.readFully(b);
                this.exception = (Exception)new ObjectInputStream(new DataByteArrayInputStream(b)).readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public boolean isOk() {
        return this.ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public String toString() {
        return "[ReplyRequest, ok=" + this.ok + " exception=" + this.exception + " ]";
    }
}

