/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.requestreply;

import com.swiftmq.tools.collection.ArrayListTool;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestHandler;
import com.swiftmq.tools.requestreply.RequestRetryValidator;
import com.swiftmq.tools.requestreply.TimeoutException;
import com.swiftmq.tools.requestreply.TransportException;
import com.swiftmq.tools.requestreply.ValidationException;
import com.swiftmq.tools.timer.TimerEvent;
import com.swiftmq.tools.timer.TimerListener;
import com.swiftmq.tools.timer.TimerRegistry;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class RequestRegistry
implements TimerListener {
    public static final long SWIFTMQ_REQUEST_TIMEOUT = Long.parseLong(System.getProperty("swiftmq.request.timeout", "60000"));
    public static final boolean DEBUG = Boolean.valueOf(System.getProperty("swiftmq.reconnect.debug", "false"));
    static final int TIMEOUT_CHECKINTERVAL = 10000;
    static boolean wrapPrivileged = false;
    ArrayList requestList = new ArrayList();
    RequestHandler requestHandler = null;
    boolean valid = true;
    boolean paused = false;
    volatile boolean requestTimeoutEnabled = true;
    Semaphore retrySem = null;
    Set retrySet = new HashSet();
    String debugString = null;

    public RequestRegistry() {
    }

    public RequestRegistry(String debugString) {
        this.debugString = debugString;
    }

    public static void setWrapPrivileged(boolean wrapPrivileged) {
        RequestRegistry.wrapPrivileged = wrapPrivileged;
    }

    public void setRequestTimeoutEnabled(boolean requestTimeoutEnabled) {
        this.requestTimeoutEnabled = requestTimeoutEnabled;
        if (requestTimeoutEnabled) {
            TimerRegistry.Singleton().addTimerListener(10000L, (TimerListener)this);
        }
    }

    public synchronized void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setRequestHandler(RequestHandler requestHandler) {
        this.requestHandler = wrapPrivileged ? new PrivilegedRequestHandler(requestHandler) : requestHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reply request(Request req) {
        if (!req.isReplyRequired()) {
            this.requestHandler.performRequest(req);
            return null;
        }
        req._sem = new Semaphore(false);
        do {
            this.processRequest(req);
            req._sem.waitHere();
            if (req.getReply() == null && req.isDoRetry()) {
                RequestRetryValidator validator;
                if (DEBUG) {
                    System.out.println(this.debugString + ": Retry: " + req);
                }
                if ((validator = req.getValidator()) != null) {
                    ValidationException validateException = null;
                    try {
                        validator.validate(req);
                    }
                    catch (ValidationException e) {
                        validateException = e;
                    }
                    if (req.isCancelledByValidator()) {
                        Reply reply = req.createReply();
                        if (validateException != null) {
                            reply.setOk(false);
                            reply.setException(validateException);
                        } else {
                            reply.setOk(true);
                        }
                        req.setReply(reply);
                        req.setDoRetry(false);
                        RequestRegistry requestRegistry = this;
                        synchronized (requestRegistry) {
                            this.retrySet.remove(req);
                            if (this.retrySet.size() == 0 && this.retrySem != null) {
                                this.retrySem.notifySingleWaiter();
                                this.retrySem = null;
                            }
                        }
                        if (DEBUG) {
                            System.out.println(this.debugString + ": Cancelled by Validator: " + req);
                        }
                    } else {
                        if (DEBUG) {
                            System.out.println(this.debugString + ": After validate: " + req);
                        }
                        req._sem.reset();
                    }
                } else {
                    if (DEBUG) {
                        System.out.println(this.debugString + ": No validator: " + req);
                    }
                    req._sem.reset();
                }
            }
            if (req.getReply() != null || !req.isDoRetry() || !DEBUG) continue;
            System.out.println(this.debugString + ": No Reply && isDoRetry: " + req);
        } while (req.getReply() == null && req.isDoRetry());
        return req.getReply();
    }

    private synchronized void processRequest(Request req) {
        if (!this.valid) {
            throw new RuntimeException("Invalid request (connection might be closed already)");
        }
        req.setReply(null);
        req.setDoRetry(false);
        if (this.requestTimeoutEnabled) {
            req.setTimeout(System.currentTimeMillis() + SWIFTMQ_REQUEST_TIMEOUT);
        }
        req.setRequestNumber(ArrayListTool.setFirstFreeOrExpand(this.requestList, req));
        if (!this.paused) {
            this.requestHandler.performRequest(req);
        } else if (DEBUG) {
            System.out.println(this.debugString + ": Paused, request NOT sent: " + req);
        }
    }

    private synchronized Semaphore setReplySynchronized(Reply reply) {
        Semaphore sem = null;
        int reqNumber = reply.getRequestNumber();
        if (reqNumber < this.requestList.size()) {
            Request req = (Request)this.requestList.get(reqNumber);
            if (req != null) {
                req.setReply(reply);
                this.requestList.set(reqNumber, null);
                sem = req._sem;
                if (req.isWasRetry()) {
                    if (DEBUG) {
                        System.out.println(this.debugString + ": Reply from Retry: " + reply);
                    }
                    this.retrySet.remove(req);
                    if (this.retrySet.size() == 0) {
                        this.retrySem.notifySingleWaiter();
                        this.retrySem = null;
                    }
                }
            } else {
                System.out.println(this.debugString + ": req == null! Reply=" + reply);
            }
        } else {
            System.out.println(this.debugString + ": reqNumber >= requestList.size(), " + reqNumber + ":" + this.requestList.size());
        }
        return sem;
    }

    public void setReply(Reply reply) {
        Semaphore sem = this.setReplySynchronized(reply);
        if (sem != null) {
            sem.notifySingleWaiter();
        } else {
            System.out.println(this.debugString + ": sem == null! Reply=" + reply);
        }
    }

    public synchronized void cancelAllRequests(TransportException exception, boolean valid) {
        for (int i = 0; i < this.requestList.size(); ++i) {
            Request req = (Request)this.requestList.get(i);
            if (req == null) continue;
            Reply reply = req.createReply();
            reply.setOk(false);
            reply.setException(exception);
            req.setReply(reply);
            req._sem.notifySingleWaiter();
        }
        this.requestList.clear();
        this.retrySet.clear();
        if (this.retrySem != null) {
            this.retrySem.notifySingleWaiter();
            this.retrySem = null;
        }
        this.valid = valid;
    }

    public synchronized void cancelRetryAllRequests() {
        this.retrySet.clear();
        if (this.retrySem != null) {
            this.retrySem.notifySingleWaiter();
            this.retrySem = null;
        }
    }

    public synchronized void retryAllRequests(Semaphore rSem) {
        this.retrySem = rSem;
        this.retrySet.clear();
        for (int i = 0; i < this.requestList.size(); ++i) {
            Request req = (Request)this.requestList.get(i);
            if (req == null) continue;
            this.retrySet.add(req);
            req.setDoRetry(true);
            req._sem.notifySingleWaiter();
        }
        this.requestList.clear();
        if (this.retrySet.size() == 0) {
            this.retrySem.notifySingleWaiter();
            this.retrySem = null;
        }
    }

    public void cancelAllRequests(TransportException exception) {
        this.cancelAllRequests(exception, true);
    }

    public synchronized void cancelRequest(Request request) {
        int idx = this.requestList.indexOf(request);
        if (idx != -1) {
            this.requestList.set(idx, null);
            request.setReply(null);
            request._sem.notifySingleWaiter();
            if (request.isDoRetry()) {
                this.retrySet.remove(request);
                if (this.retrySem != null) {
                    this.retrySem.notifySingleWaiter();
                    this.retrySem = null;
                }
            }
        }
    }

    @Override
    public synchronized void performTimeAction(TimerEvent evt) {
        long actTime = System.currentTimeMillis();
        for (int i = 0; i < this.requestList.size(); ++i) {
            Request req = (Request)this.requestList.get(i);
            if (req == null || req.getTimeout() == -1L || req.getTimeout() >= actTime) continue;
            this.requestList.set(i, null);
            Reply reply = req.createReply();
            reply.setOk(false);
            reply.setException(new TimeoutException("Request time out (" + SWIFTMQ_REQUEST_TIMEOUT + ") ms!"));
            reply.setTimeout(true);
            req.setReply(reply);
            req._sem.notifySingleWaiter();
        }
    }

    public synchronized void close() {
        if (this.requestTimeoutEnabled) {
            TimerRegistry.Singleton().removeTimerListener(10000L, (TimerListener)this);
        }
    }

    private abstract class PrivilegedRequestAction
    implements PrivilegedAction {
        Request myRequest = null;

        public PrivilegedRequestAction(Request request) {
            this.myRequest = request;
        }
    }

    private class PrivilegedRequestHandler
    implements RequestHandler {
        RequestHandler realHandler = null;

        public PrivilegedRequestHandler(RequestHandler realHandler) {
            this.realHandler = realHandler;
        }

        @Override
        public void performRequest(Request request) {
            AccessController.doPrivileged(new PrivilegedRequestAction(request){

                public Object run() {
                    PrivilegedRequestHandler.this.realHandler.performRequest(this.myRequest);
                    return null;
                }
            });
        }
    }
}

