/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.requestreply;

import com.swiftmq.tools.collection.ArrayListTool;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.ReplyHandler;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestService;
import com.swiftmq.tools.requestreply.TransportException;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RequestServiceRegistry {
    ReplyHandler replyHandler;
    ArrayList dispatchList = new ArrayList();
    ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    int nextFree = -1;

    public void setReplyHandler(ReplyHandler replyHandler) {
        this.replyHandler = replyHandler;
    }

    public int getNumberServices() {
        this.rwl.readLock().lock();
        try {
            int n = this.dispatchList.size();
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public int getNextFreeDispatchId() {
        this.rwl.readLock().lock();
        try {
            if (this.nextFree == -1) {
                this.nextFree = ArrayListTool.setFirstFreeOrExpand(this.dispatchList, null);
            }
            int n = this.nextFree;
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRequestService(RequestService requestService) {
        this.rwl.writeLock().lock();
        try {
            int idx;
            this.nextFree = -1;
            int n = idx = ArrayListTool.setFirstFreeOrExpand(this.dispatchList, requestService);
            return n;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public void removeRequestService(int dispatchId) {
        this.rwl.writeLock().lock();
        try {
            this.nextFree = -1;
            this.dispatchList.set(dispatchId, null);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public RequestService getRequestService(int dispatchId) {
        this.rwl.readLock().lock();
        try {
            RequestService requestService = (RequestService)this.dispatchList.get(dispatchId);
            return requestService;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    protected boolean isSendExceptionEnabled() {
        return true;
    }

    public void dispatch(Request request) {
        RequestService requestService;
        if (request.isReplyRequired()) {
            request.setReplyHandler(this.replyHandler);
        }
        if ((requestService = this.getRequestService(request.getDispatchId())) != null) {
            requestService.serviceRequest(request);
        } else if (request.isReplyRequired() && this.isSendExceptionEnabled()) {
            Reply reply = request.createReply();
            reply.setOk(false);
            reply.setException(new TransportException("No requestService for request defined: " + request));
            reply.send();
        }
    }
}

