/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SecureClassLoaderObjectInputStream
extends ObjectInputStream {
    public static final String[] serializablePackages;
    public static final String[] trusted;
    private static final ClassLoader FALLBACK_CLASS_LOADER;
    private final ClassLoader inLoader;
    private List<String> trustedPackages = new ArrayList<String>();
    private boolean trustAllPackages = false;

    public SecureClassLoaderObjectInputStream(InputStream in) throws IOException {
        super(in);
        this.inLoader = in.getClass().getClassLoader();
        this.trustedPackages.addAll(Arrays.asList(trusted));
        this.trustedPackages.addAll(Arrays.asList(serializablePackages));
        if (trusted.length == 1 && trusted[0].equals("*")) {
            this.trustAllPackages = true;
        }
    }

    public SecureClassLoaderObjectInputStream(InputStream in, ClassLoader inLoader) throws IOException {
        super(in);
        this.inLoader = inLoader;
        this.trustedPackages.addAll(Arrays.asList(trusted));
        this.trustedPackages.addAll(Arrays.asList(serializablePackages));
        if (trusted.length == 1 && trusted[0].equals("*")) {
            this.trustAllPackages = true;
        }
    }

    public static boolean isAllAllowed() {
        return serializablePackages.length == 1 && serializablePackages[0].equals("*");
    }

    public static Class<?> loadSimpleType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return byte[].class;
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return Byte[].class;
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return Object[].class;
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return String[].class;
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return String.class;
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name)) {
            return Boolean.class;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name)) {
            return Integer.class;
        }
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name)) {
            return Long.class;
        }
        if ("long".equals(name)) {
            return Long.TYPE;
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name)) {
            return Short.class;
        }
        if ("short".equals(name)) {
            return Short.TYPE;
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name)) {
            return Byte.class;
        }
        if ("byte".equals(name)) {
            return Byte.TYPE;
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name)) {
            return Float.class;
        }
        if ("float".equals(name)) {
            return Float.TYPE;
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name)) {
            return Double.class;
        }
        if ("double".equals(name)) {
            return Double.TYPE;
        }
        if ("void".equals(name)) {
            return Void.TYPE;
        }
        return null;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        ClassLoader cl = this.inLoader;
        Class<?> clazz = this.load(classDesc.getName(), cl, this.inLoader);
        this.checkSecurity(clazz);
        return clazz;
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader cl = this.inLoader;
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.load(interfaces[i], cl);
        }
        Class<?> clazz = null;
        try {
            clazz = Proxy.getProxyClass(cl, cinterfaces);
        }
        catch (IllegalArgumentException e) {
            try {
                clazz = Proxy.getProxyClass(this.inLoader, cinterfaces);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                clazz = Proxy.getProxyClass(FALLBACK_CLASS_LOADER, cinterfaces);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (clazz != null) {
            this.checkSecurity(clazz);
            return clazz;
        }
        throw new ClassNotFoundException(null);
    }

    private boolean trustAllPackages() {
        return this.trustAllPackages || this.trustedPackages.size() == 1 && this.trustedPackages.get(0).equals("*");
    }

    private void checkSecurity(Class clazz) throws ClassNotFoundException {
        if (!clazz.isPrimitive() && clazz.getPackage() != null && !this.trustAllPackages()) {
            boolean found = false;
            for (String packageName : this.getTrustedPackages()) {
                if (!clazz.getPackage().getName().equals(packageName) && !clazz.getPackage().getName().startsWith(packageName + ".")) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new ClassNotFoundException("Forbidden " + clazz + "! This class is not trusted to be serialized as ObjectMessage payload. ");
            }
        }
    }

    private Class<?> load(String className, ClassLoader ... cl) throws ClassNotFoundException {
        Class<?> clazz = SecureClassLoaderObjectInputStream.loadSimpleType(className);
        if (clazz != null) {
            return clazz;
        }
        for (ClassLoader loader : cl) {
            try {
                Class<?> answer = Class.forName(className, false, loader);
                return answer;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return Class.forName(className, false, FALLBACK_CLASS_LOADER);
    }

    public List<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    public void setTrustedPackages(List<String> trustedPackages) {
        this.trustedPackages = trustedPackages;
    }

    public void addTrustedPackage(String trustedPackage) {
        this.trustedPackages.add(trustedPackage);
    }

    public boolean isTrustAllPackages() {
        return this.trustAllPackages;
    }

    public void setTrustAllPackages(boolean trustAllPackages) {
        this.trustAllPackages = trustAllPackages;
    }

    static {
        FALLBACK_CLASS_LOADER = SecureClassLoaderObjectInputStream.class.getClassLoader();
        trusted = System.getProperty("swiftmq.security.objectmessage.trusted.pkg", "*").split(",");
        serializablePackages = "java.lang,javax.security,java.util,com.swiftmq,com.thoughtworks.xstream".split(",");
    }
}

