/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class Store {
    private String fileProperty;
    private String passwordProperty;
    private String filePath = System.getProperty("javax.net.ssl.trustStore");
    private String password = System.getProperty("javax.net.ssl.trustStorePassword");
    protected final KeyStore store = this.loadStore();

    private KeyStore loadStore() throws Exception {
        if (this.filePath == null) {
            throw new Exception("Store file required. Provide one with with " + this.fileProperty + ".");
        }
        if (this.password == null) {
            throw new Exception("Keystore file required. Provide one with " + this.passwordProperty + ".");
        }
        File file = new File(this.filePath);
        if (!file.exists()) {
            throw new Exception("Store file not found at: " + this.filePath + ".");
        }
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(file), this.password.toCharArray());
        return ks;
    }

    public void addCert(String alias, byte[] cert) throws Exception {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(cert);
        X509Certificate x509Cert = (X509Certificate)certFactory.generateCertificate(in);
        this.store.setCertificateEntry(alias, x509Cert);
        this.save();
    }

    public void removeCert(String alias) throws Exception {
        this.store.deleteEntry(alias);
        this.save();
    }

    public void save() throws Exception {
        File newFile = new File(this.filePath);
        FileOutputStream out = new FileOutputStream(newFile);
        this.store.store(out, this.password.toCharArray());
    }
}

