/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.tracking;

import com.swiftmq.tools.collection.SortedDupsCollection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;

public class Analyzer {
    static boolean hasSeqNo = Boolean.valueOf(System.getProperty("hasseqno", "true"));
    static Map root = new TreeMap();

    private static void store(String line) {
        try {
            StringTokenizer t = new StringTokenizer(line, "-");
            int cnt = t.countTokens();
            if (cnt < 6) {
                return;
            }
            String time = t.nextToken();
            String prefix = t.nextToken();
            String seqNo = null;
            if (hasSeqNo && cnt == 7) {
                seqNo = t.nextToken();
            }
            String destination = t.nextToken();
            String msgId = t.nextToken();
            String callStack = t.nextToken();
            String operation = t.nextToken();
            String id = seqNo != null ? seqNo + "-" + msgId : msgId;
            Collection collection = (Collection)root.get(id);
            if (collection == null) {
                collection = new SortedDupsCollection(new TreeSet());
                root.put(id, collection);
            }
            collection.add(new Entry(time, callStack, operation));
        }
        catch (Exception e) {
            System.out.println(line);
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            int linesOk = -1;
            if (args.length == 1) {
                linesOk = Integer.parseInt(args[0]);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = null;
            while ((line = reader.readLine()) != null) {
                Analyzer.store(line);
            }
            reader.close();
            for (Map.Entry e2 : root.entrySet()) {
                Collection c = (Collection)e2.getValue();
                if (linesOk == -1 || c.size() == linesOk) continue;
                System.out.println(e2.getKey());
                Iterator iter3 = c.iterator();
                while (iter3.hasNext()) {
                    System.out.println("    " + iter3.next());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class Entry
    implements Comparable {
        String time;
        String callStack;
        String operation;

        public Entry(String time, String callStack, String operation) {
            this.time = time;
            this.callStack = callStack;
            this.operation = operation;
        }

        public int compareTo(Object o) {
            return this.time.compareTo(((Entry)o).time);
        }

        public String toString() {
            return this.time + "-" + this.callStack + " " + this.operation;
        }
    }
}

