/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.tracking;

import com.swiftmq.jms.MessageImpl;
import com.swiftmq.util.SwiftUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MessageTracker {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyMMdd:HH:mm:ss.SSS");
    public static boolean enabled = Boolean.valueOf(System.getProperty("swiftmq.message.tracking.enabled", "false"));
    private static String filename = System.getProperty("swiftmq.message.tracking.filename", "track.out");
    private static String sequenceProp = System.getProperty("swiftmq.message.tracking.sequenceprop");
    private static long rolloverSize = Integer.parseInt(System.getProperty("swiftmq.message.tracking.rolloversize", "10240")) * 1024;
    private static int keepFiles = Integer.parseInt(System.getProperty("swiftmq.message.tracking.keepfiles", "10"));
    String prefix = null;
    List files = new ArrayList();
    File current = null;
    PrintWriter writer = null;
    int idx = 0;

    private MessageTracker() {
    }

    public static MessageTracker getInstance() {
        return InstanceHolder.instance;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private File newFile(int n) {
        if (this.files.size() == keepFiles) {
            File f = (File)this.files.remove(0);
            f.delete();
        }
        File file = new File(n + "_" + filename);
        this.files.add(file);
        return file;
    }

    public synchronized void track(MessageImpl msg, String[] callStack, String operation) {
        try {
            if (this.current == null) {
                this.current = this.newFile(this.idx++);
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(this.current)));
            }
            StringBuffer b = new StringBuffer(format.format(new Date()));
            if (this.prefix != null) {
                b.append("-");
                b.append(this.prefix);
            }
            if (sequenceProp != null && msg.propertyExists(sequenceProp)) {
                b.append("-");
                b.append(SwiftUtilities.fillLeft(msg.getObjectProperty(sequenceProp).toString(), 6, '0'));
            }
            b.append("-");
            b.append(msg.getJMSDestination());
            if (msg.getJMSMessageID() != null) {
                b.append("-");
                b.append(msg.getJMSMessageID());
            }
            b.append("-");
            for (int i = 0; i < callStack.length; ++i) {
                if (i > 0) {
                    b.append("/");
                }
                b.append(callStack[i]);
            }
            b.append("-");
            b.append(operation);
            this.writer.println(b.toString());
            this.writer.flush();
            if (this.current.length() >= rolloverSize) {
                this.writer.close();
                this.current = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class InstanceHolder {
        public static MessageTracker instance = new MessageTracker();

        private InstanceHolder() {
        }
    }
}

