/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.util;

import com.swiftmq.swiftlet.trace.TraceSpace;
import com.swiftmq.tools.util.UTFUtils;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;

public class DataByteBufferOutputStream
implements DataOutput {
    ByteBuffer buffer = null;
    int initialSize;
    int extendSize;
    boolean direct;
    TraceSpace traceSpace = null;
    String tracePrefix = null;

    public DataByteBufferOutputStream(int initialSize, int extendSize, boolean direct) {
        this.initialSize = initialSize;
        this.extendSize = extendSize;
        this.direct = direct;
        this.buffer = direct ? ByteBuffer.allocateDirect(initialSize) : ByteBuffer.allocate(initialSize);
    }

    private void ensure(int size) {
        if (this.buffer.remaining() < size) {
            ByteBuffer b;
            int ext = size >= this.extendSize ? size + this.extendSize : this.extendSize;
            ByteBuffer byteBuffer = b = this.direct ? ByteBuffer.allocateDirect(this.buffer.capacity() + ext) : ByteBuffer.allocate(this.buffer.capacity() + ext);
            if (this.traceSpace != null && this.traceSpace.enabled) {
                this.traceSpace.trace(this.tracePrefix, "DataByteBufferOutputStream, direct=" + this.direct + ", current buffersize=" + this.buffer.capacity() + ", ext=" + ext + ", new buffersize=" + b.capacity());
            }
            this.buffer.flip();
            b.put(this.buffer);
            this.buffer = b;
        }
    }

    private void put(int b) {
        this.buffer.put((byte)b);
    }

    public void setTrace(TraceSpace traceSpace, String tracePrefix) {
        this.traceSpace = traceSpace;
        this.tracePrefix = tracePrefix;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getCount() {
        return this.buffer.position();
    }

    @Override
    public void write(int b) throws IOException {
        this.ensure(1);
        this.put(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensure(len);
        this.buffer.put(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.ensure(1);
        this.put(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.ensure(2);
        this.put(v >>> 8 & 0xFF);
        this.put(v & 0xFF);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.ensure(2);
        this.put(v >>> 8 & 0xFF);
        this.put(v & 0xFF);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ensure(4);
        this.buffer.putInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ensure(8);
        this.buffer.putLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.ensure(8);
        this.buffer.putFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.ensure(8);
        this.buffer.putDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        this.ensure(len);
        for (int i = 0; i < len; ++i) {
            this.put((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        this.ensure(len * 2);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.put(v >>> 8 & 0xFF);
            this.put(v & 0xFF);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int utfCount = UTFUtils.countUTFBytes(s);
        if (utfCount > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(utfCount);
        this.writeUTFBytesToBuffer(s);
    }

    void writeUTFBytesToBuffer(String str) throws IOException {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                this.write((byte)charValue);
                continue;
            }
            if (charValue <= '\u07ff') {
                this.write((byte)(0xC0 | 0x1F & charValue >> 6));
                this.write((byte)(0x80 | 0x3F & charValue));
                continue;
            }
            this.write((byte)(0xE0 | 0xF & charValue >> 12));
            this.write((byte)(0x80 | 0x3F & charValue >> 6));
            this.write((byte)(0x80 | 0x3F & charValue));
        }
    }

    public void rewind() {
        this.buffer.clear();
    }
}

