/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DynamicBufferedOutputStream
extends FilterOutputStream {
    protected static final int DEFAULT_MAX_BUFFER_SIZE = 8192;
    protected static final int DEFAULT_EXTEND_SIZE = 512;
    protected byte[] buf;
    protected int count;
    int maxSize = 8192;
    int extendSize = 512;

    public DynamicBufferedOutputStream(OutputStream out, int extendSize, int maxSize) {
        super(out);
        if (maxSize > 0) {
            this.maxSize = maxSize;
        }
        if (extendSize > 0) {
            this.extendSize = extendSize;
        }
        this.buf = new byte[extendSize];
    }

    public DynamicBufferedOutputStream(OutputStream out) {
        this(out, 512, 8192);
    }

    public DynamicBufferedOutputStream(OutputStream out, int size) {
        this(out, 512, size);
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    private void extendBuffer(int n) throws IOException {
        int newSize = this.count + n;
        byte[] b = new byte[newSize];
        System.arraycopy(this.buf, 0, b, 0, this.buf.length);
        this.buf = b;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.extendBuffer(this.extendSize);
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len > this.buf.length - this.count) {
            this.extendBuffer(len);
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

