/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.util;

import java.io.InputStream;

public class FastByteArrayInputStream
extends InputStream {
    byte[] buffer = null;
    int pos = 0;
    int count = 0;

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
        this.pos = 0;
        this.count = buffer.length;
    }

    public void setBuffer(byte[] buffer, int pos, int len) {
        this.buffer = buffer;
        this.pos = pos;
        this.count = pos + len;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buffer[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        System.arraycopy(this.buffer, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }
}

