/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.util;

import com.swiftmq.tools.util.UTFUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.io.UTFDataFormatException;

public class LazyUTF8String
implements Serializable {
    String s = null;
    byte[] buffer = null;
    int utfLength = 0;

    public LazyUTF8String(DataInput in) throws IOException {
        this.utfLength = in.readUnsignedShort();
        this.buffer = new byte[this.utfLength + 2];
        in.readFully(this.buffer, 2, this.utfLength);
        this.buffer[0] = (byte)(this.utfLength >>> 8 & 0xFF);
        this.buffer[1] = (byte)(this.utfLength & 0xFF);
    }

    public LazyUTF8String(String s) {
        try {
            if (s == null) {
                System.out.println("s==null");
                throw new NullPointerException();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw e;
        }
        this.s = s;
    }

    private String bufferToString() throws Exception {
        return UTFUtils.convertFromUTF8(this.buffer, 2, this.utfLength);
    }

    private byte[] stringToBuffer() throws Exception {
        this.utfLength = UTFUtils.countUTFBytes(this.s);
        if (this.utfLength > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] b = new byte[this.utfLength + 2];
        int count = 0;
        count = UTFUtils.writeShortToBuffer(this.utfLength, b, count);
        UTFUtils.writeUTFBytesToBuffer(this.s, b, count);
        return b;
    }

    public String getString() {
        return this.getString(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(boolean clear) {
        if (this.s == null) {
            LazyUTF8String lazyUTF8String = this;
            synchronized (lazyUTF8String) {
                if (this.s == null) {
                    try {
                        this.s = this.bufferToString();
                        if (clear) {
                            this.buffer = null;
                            this.utfLength = 0;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBuffer() {
        if (this.buffer == null) {
            LazyUTF8String lazyUTF8String = this;
            synchronized (lazyUTF8String) {
                if (this.buffer == null) {
                    try {
                        this.buffer = this.stringToBuffer();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.buffer;
    }

    public void writeContent(DataOutput out) throws IOException {
        out.write(this.getBuffer());
    }

    public String toString() {
        return "[LazyUTF8String, s=" + this.s + ", buffer=" + this.buffer + "]";
    }
}

