/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.util;

public class UninterruptableWaiter {
    public static void doWait(Object waiter) {
        boolean wasInterrupted = Thread.interrupted();
        boolean ok = false;
        do {
            try {
                waiter.wait();
                ok = true;
            }
            catch (InterruptedException e) {
                ok = false;
                wasInterrupted = true;
            }
        } while (!ok);
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static void doWait(Object waiter, long timeout) {
        if (timeout == 0L) {
            UninterruptableWaiter.doWait(waiter);
            return;
        }
        boolean wasInterrupted = Thread.interrupted();
        boolean ok = false;
        do {
            long start = System.currentTimeMillis();
            try {
                waiter.wait(timeout);
                ok = true;
            }
            catch (InterruptedException e) {
                long delta = System.currentTimeMillis() - start;
                ok = (timeout -= delta) <= 0L;
                wasInterrupted = true;
            }
        } while (!ok);
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

