/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.versioning;

import com.swiftmq.jms.BytesMessageImpl;
import com.swiftmq.jms.DestinationFactory;
import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.dump.DumpableFactory;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import com.swiftmq.tools.versioning.Versioned;
import com.swiftmq.tools.versioning.VersionedException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jms.BytesMessage;

public class Versionable
implements Dumpable,
Serializable {
    List versionedList = new ArrayList();
    VEntry selected = null;
    ClassLoader classLoader = null;

    public static Versionable toVersionable(BytesMessage msg) throws Exception {
        byte[] b = new byte[(int)((BytesMessageImpl)msg)._getBodyLength()];
        msg.readBytes(b);
        DataByteArrayInputStream dis = new DataByteArrayInputStream(b);
        Versionable v = new Versionable();
        v.readContent(dis);
        return v;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void transferToMessage(BytesMessage msg) throws Exception {
        DataByteArrayOutputStream dos = new DataByteArrayOutputStream();
        this.writeContent(dos);
        msg.writeBytes(dos.getBuffer(), 0, dos.getCount());
    }

    public void addVersioned(int version, Versioned versioned, String factoryClass) {
        this.versionedList.add(new VEntry(version, versioned, factoryClass));
    }

    private String print(int[] a) {
        StringBuffer b = new StringBuffer("[");
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(a[i]);
        }
        b.append("]");
        return b.toString();
    }

    public int selectVersions(int[] versions) throws VersionedException {
        block0: for (int i = 0; i < this.versionedList.size(); ++i) {
            VEntry entry = (VEntry)this.versionedList.get(i);
            for (int j = versions.length - 1; j >= 0; --j) {
                if (entry.versioned.getVersion() != -1 && entry.versioned.getVersion() != versions[j]) continue;
                this.selected = entry;
                continue block0;
            }
        }
        if (this.selected == null) {
            throw new VersionedException("Unable to find a versioned object matching this versions: " + this.print(versions));
        }
        return this.selected.version;
    }

    private Object create(VEntry entry) throws Exception {
        DataByteArrayInputStream dis = new DataByteArrayInputStream();
        dis.setBuffer(entry.versioned.getPayload(), 0, entry.versioned.getLength());
        Object obj = null;
        if (entry.version == -1) {
            obj = DestinationFactory.createDestination(dis);
        } else {
            DumpableFactory factory = null;
            factory = this.classLoader == null ? (DumpableFactory)Class.forName(entry.factoryClass).newInstance() : (DumpableFactory)this.classLoader.loadClass(entry.factoryClass).newInstance();
            Dumpable d = factory.createDumpable(dis.readInt());
            d.readContent(dis);
            obj = d;
        }
        return obj;
    }

    public Object createVersionedObject() throws Exception {
        if (this.selected == null) {
            throw new Exception("No version selected!");
        }
        return this.create(this.selected);
    }

    public Object createCurrentVersionObject() throws Exception {
        return this.create((VEntry)this.versionedList.get(this.versionedList.size() - 1));
    }

    @Override
    public int getDumpId() {
        return 0;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        out.writeInt(this.versionedList.size());
        for (int i = 0; i < this.versionedList.size(); ++i) {
            VEntry entry = (VEntry)this.versionedList.get(i);
            out.writeInt(entry.version);
            entry.versioned.writeContent(out);
            out.writeUTF(entry.factoryClass);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.versionedList = new ArrayList();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            int version = in.readInt();
            Versioned versioned = new Versioned();
            versioned.readContent(in);
            String factoryClass = in.readUTF();
            this.versionedList.add(new VEntry(version, versioned, factoryClass));
        }
    }

    public String toString() {
        return "[Versionable, versionedList=" + this.versionedList + "]";
    }

    private class VEntry {
        int version = 0;
        Versioned versioned = null;
        String factoryClass = null;

        public VEntry(int version, Versioned versioned, String factoryClass) {
            this.version = version;
            this.versioned = versioned;
            this.factoryClass = factoryClass;
        }

        public String toString() {
            return "[VEntry, version=" + this.version + ", versioned=" + this.versioned + ", factoryClass=" + this.factoryClass + "]";
        }
    }
}

