/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.versioning;

import com.swiftmq.tools.dump.Dumpable;
import com.swiftmq.tools.versioning.VersionObject;
import com.swiftmq.tools.versioning.VersionVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Versioned
implements VersionObject,
Dumpable {
    int version = 0;
    byte[] payload = null;
    int length = 0;

    public Versioned(int version, byte[] newpayload, int length) {
        this.version = version;
        this.length = length;
        this.payload = new byte[length];
        System.arraycopy(newpayload, 0, this.payload, 0, length);
    }

    public Versioned() {
    }

    @Override
    public int getDumpId() {
        return 1;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        out.writeInt(this.version);
        if (this.payload != null) {
            out.writeByte(1);
            out.writeInt(this.length);
            out.write(this.payload, 0, this.length);
        } else {
            out.writeByte(0);
        }
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        this.version = in.readInt();
        byte set = in.readByte();
        if (set == 1) {
            this.length = in.readInt();
            this.payload = new byte[this.length];
            in.readFully(this.payload);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void accept(VersionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "[Versioned, version=" + this.version + ", length=" + this.length + ", payload=" + this.payload + "]";
    }
}

