/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.tools.versioning;

import com.swiftmq.tools.collection.RingBuffer;
import com.swiftmq.tools.versioning.Versioned;
import com.swiftmq.tools.versioning.VersionedConverter;
import com.swiftmq.tools.versioning.VersionedDumpable;
import com.swiftmq.tools.versioning.VersionedException;
import com.swiftmq.tools.versioning.VersionedFactory;
import com.swiftmq.tools.versioning.event.VersionedListener;

public class VersionedProcessor {
    int[] acceptedVersions = null;
    VersionedListener listener = null;
    VersionedConverter converter = null;
    VersionedFactory factory = null;
    RingBuffer buffer = null;

    public VersionedProcessor(int[] acceptedVersions, VersionedListener listener, VersionedConverter converter, VersionedFactory factory, boolean useBuffer) {
        this.acceptedVersions = acceptedVersions;
        this.listener = listener;
        this.converter = converter;
        this.factory = factory;
        if (useBuffer && listener == null) {
            this.buffer = new RingBuffer(32);
        }
    }

    public void setListener(int[] acceptedVersions, VersionedListener listener) {
        this.acceptedVersions = acceptedVersions;
        this.listener = listener;
    }

    public void setConverter(VersionedConverter converter) {
        this.converter = converter;
    }

    public void setFactory(VersionedFactory factory) {
        this.factory = factory;
    }

    protected boolean isReady() {
        return true;
    }

    public void processBuffer() {
        if (this.buffer == null) {
            return;
        }
        int size = this.buffer.getSize();
        for (int i = 0; i < size; ++i) {
            this.process((VersionedDumpable)this.buffer.remove());
        }
    }

    public void process(Versioned versioned) {
        try {
            this.process(new VersionedDumpable(versioned.getVersion(), this.factory.createDumpable(versioned)));
        }
        catch (VersionedException e) {
            this.listener.onException(e);
        }
    }

    public void process(VersionedDumpable vd) {
        if (this.listener == null || !this.isReady()) {
            if (this.buffer != null) {
                this.buffer.add(vd);
            }
            return;
        }
        try {
            boolean found = false;
            for (int i = 0; i < this.acceptedVersions.length; ++i) {
                if (vd.getVersion() != this.acceptedVersions[i]) continue;
                found = true;
                break;
            }
            if (!found) {
                this.converter.convert(vd, this.acceptedVersions);
            }
            this.listener.onAccept(vd);
        }
        catch (VersionedException e) {
            this.listener.onException(e);
        }
    }
}

