/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.context;

import com.swirlds.base.context.internal.GlobalContext;
import com.swirlds.base.context.internal.ThreadLocalContext;
import edu.umd.cs.findbugs.annotations.NonNull;

public interface Context {
    public void add(@NonNull String var1, @NonNull String var2);

    public void remove(@NonNull String var1);

    @NonNull
    default public AutoCloseable addWithRemovalOnClose(@NonNull String key, @NonNull String value) {
        this.add(key, value);
        return () -> this.remove(key);
    }

    @NonNull
    default public void add(@NonNull String key, int value) {
        this.add(key, Integer.toString(value));
    }

    @NonNull
    default public AutoCloseable addWithRemovalOnClose(@NonNull String key, int value) {
        return this.addWithRemovalOnClose(key, Integer.toString(value));
    }

    @NonNull
    default public void add(@NonNull String key, long value) {
        this.add(key, Long.toString(value));
    }

    @NonNull
    default public AutoCloseable addWithRemovalOnClose(@NonNull String key, long value) {
        return this.addWithRemovalOnClose(key, Long.toString(value));
    }

    @NonNull
    default public void add(@NonNull String key, float value) {
        this.add(key, Float.toString(value));
    }

    @NonNull
    default public AutoCloseable addWithRemovalOnClose(@NonNull String key, float value) {
        return this.addWithRemovalOnClose(key, Float.toString(value));
    }

    @NonNull
    default public void add(@NonNull String key, double value) {
        this.add(key, Double.toString(value));
    }

    @NonNull
    default public AutoCloseable addWithRemovalOnClose(@NonNull String key, double value) {
        return this.addWithRemovalOnClose(key, Double.toString(value));
    }

    @NonNull
    default public void add(@NonNull String key, boolean value) {
        this.add(key, Boolean.toString(value));
    }

    @NonNull
    default public AutoCloseable addWithRemovalOnClose(@NonNull String key, boolean value) {
        return this.addWithRemovalOnClose(key, Boolean.toString(value));
    }

    @NonNull
    public static Context getGlobalContext() {
        return GlobalContext.getInstance();
    }

    @NonNull
    public static Context getThreadLocalContext() {
        return ThreadLocalContext.getInstance();
    }
}

