/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.context.internal;

import com.swirlds.base.context.Context;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ThreadLocalContext
implements Context {
    private static final ThreadLocalContext INSTANCE = new ThreadLocalContext();
    private final ThreadLocal<Map<String, String>> contextThreadLocal = new ThreadLocal();

    private ThreadLocalContext() {
    }

    @Override
    public AutoCloseable add(@NonNull String key, @NonNull String value) {
        Objects.requireNonNull(key, "key must not be null");
        Objects.requireNonNull(value, "value must not be null");
        Map<String, String> contextMap = this.contextThreadLocal.get();
        if (contextMap == null) {
            contextMap = new HashMap<String, String>();
            this.contextThreadLocal.set(contextMap);
        }
        contextMap.put(key, value);
        return () -> this.remove(key);
    }

    @Override
    public void remove(@NonNull String key) {
        Objects.requireNonNull(key, "key must not be null");
        Map<String, String> contextMap = this.contextThreadLocal.get();
        if (contextMap != null) {
            contextMap.remove(key);
        }
    }

    public void clear() {
        Map<String, String> contextMap = this.contextThreadLocal.get();
        if (contextMap != null) {
            contextMap.clear();
        }
    }

    @NonNull
    public static ThreadLocalContext getInstance() {
        return INSTANCE;
    }

    @NonNull
    public static Map<String, String> getContextMap() {
        Map<String, String> current = ThreadLocalContext.INSTANCE.contextThreadLocal.get();
        if (current != null) {
            return Collections.unmodifiableMap(current);
        }
        return Map.of();
    }
}

