/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.state;

import com.swirlds.base.state.LifecycleException;
import com.swirlds.base.state.LifecyclePhase;
import com.swirlds.base.state.Startable;
import com.swirlds.base.state.Stoppable;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public interface Lifecycle
extends Startable,
Stoppable {
    @NonNull
    public LifecyclePhase getLifecyclePhase();

    default public void throwIfNotInPhase(@NonNull LifecyclePhase phase) {
        this.throwIfNotInPhase(phase, "object is in an unexpected phase");
    }

    default public void throwIfNotInPhase(@NonNull LifecyclePhase phase, @Nullable String errorMessage) {
        Objects.requireNonNull(phase, "phase must not be null");
        LifecyclePhase currentPhase = this.getLifecyclePhase();
        if (currentPhase != phase) {
            throw new LifecycleException(errorMessage + ": current phase = " + currentPhase + ", expected phase = " + phase);
        }
    }
}

