/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public final class ArgumentUtils {
    public static final String ERROR_ARGUMENT_NULL = "The supplied argument '%s' cannot be null!";
    public static final String ERROR_ARGUMENT_BLANK = "The supplied argument '%s' cannot be blank!";

    private ArgumentUtils() throws IllegalAccessException {
        throw new IllegalAccessException("Cannot instantiate utility class!");
    }

    @NonNull
    public static String throwArgBlank(@NonNull String argument, @NonNull String argumentName) throws NullPointerException, IllegalArgumentException {
        Objects.requireNonNull(argument, ERROR_ARGUMENT_NULL.formatted(argumentName));
        if (argument.isBlank()) {
            throw new IllegalArgumentException(ERROR_ARGUMENT_BLANK.formatted(argumentName));
        }
        return argument;
    }
}

