/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.context.internal;

import com.swirlds.base.context.Context;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class GlobalContext
implements Context {
    private static final GlobalContext INSTANCE = new GlobalContext();
    private final Map<String, String> contextMap = new ConcurrentHashMap<String, String>();

    private GlobalContext() {
    }

    @Override
    public AutoCloseable add(@NonNull String key, @NonNull String value) {
        Objects.requireNonNull(key, "key must not be null");
        Objects.requireNonNull(value, "value must not be null");
        this.contextMap.put(key, value);
        return () -> this.remove(key);
    }

    @Override
    public void remove(@NonNull String key) {
        Objects.requireNonNull(key, "key must not be null");
        this.contextMap.remove(key);
    }

    public void clear() {
        this.contextMap.clear();
    }

    @NonNull
    public static GlobalContext getInstance() {
        return INSTANCE;
    }

    @NonNull
    public static Map<String, String> getContextMap() {
        return Collections.unmodifiableMap(GlobalContext.INSTANCE.contextMap);
    }
}

