/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli;

import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import picocli.CommandLine;

@CommandLine.Command(name="pcli", version={"0.34.0"}, mixinStandardHelpOptions=true, description={"Miscellaneous platform utilities."})
public class PlatformCli
extends AbstractCommand {
    @CommandLine.Option(names={"-l", "--load", "--cp"}, scope=CommandLine.ScopeType.INHERIT, description={"A path where additional java libs should be loaded from. Can be a path to a jar file or a path to a directory containing jar files."})
    private void setLoadPath(List<Path> loadPath) {
        throw this.buildParameterException("The load path parameter is expected to be parsed prior to the JVM being started");
    }

    @CommandLine.Option(names={"-j", "--jvm"}, scope=CommandLine.ScopeType.INHERIT, description={"An argument that will be passed to the JVM, e.g. '-Xmx10g'"})
    private void setJvmArgs(List<String> jvmArgs) {
        throw this.buildParameterException("The jvm args parameter is expected to be parsed prior to the JVM being started. This argument is included here for documentation purposes only.");
    }

    @CommandLine.Option(names={"-d", "--debug"}, scope=CommandLine.ScopeType.INHERIT, description={"Pause the JVM at startup, and wait until a debugger is attached to port 8888 before continuing."})
    private void setDebug(boolean debug) {
        throw this.buildParameterException("The debug parameter is expected to be parsed prior to the JVM being started. This argument is included here for documentation purposes only.");
    }

    @CommandLine.Option(names={"-m", "--memory"}, scope=CommandLine.ScopeType.INHERIT, description={"Set the amount of memory to allocate to the JVM, in gigabytes. '-m 16' is equivalent to '-j -Xmx16g'."})
    private void setJvmArgs(int memory) {
        throw this.buildParameterException("The memory parameter is expected to be parsed prior to the JVM being started. This argument is included here for documentation purposes only.");
    }

    @CommandLine.Option(names={"-L", "--log4j"}, scope=CommandLine.ScopeType.INHERIT, description={"The path where the log4j configuration file can be found."})
    private void setLog4jPath(Path log4jPath) {
        if (!Files.exists(log4jPath, new LinkOption[0])) {
            throw this.buildParameterException("File " + log4jPath + " does not exist.");
        }
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        context.setConfigLocation(log4jPath.toUri());
    }

    private static List<Subcommand> getSubcommands() {
        ClassGraph classGraph = new ClassGraph().enableClassInfo().enableAnnotationInfo();
        ArrayList<Subcommand> subcommands = new ArrayList<Subcommand>();
        try (ScanResult scanResult = classGraph.scan();){
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(SubcommandOf.class.getName())) {
                Class subcommandClass = classInfo.loadClass();
                SubcommandOf subcommandOf = (SubcommandOf)classInfo.getAnnotationInfo(SubcommandOf.class.getName()).loadClassAndInstantiate();
                Class<?> parentClass = subcommandOf.value();
                subcommands.add(new Subcommand(subcommandClass, parentClass));
            }
        }
        return subcommands;
    }

    private static Map<Class<?>, Class<?>> buildParentMap(List<Subcommand> subcommands) {
        HashMap map = new HashMap();
        subcommands.forEach(subcommand -> map.put(subcommand.subcommandClass, subcommand.parentClass));
        return map;
    }

    private static Map<Class<?>, CommandLine> buildCommandLines(List<Subcommand> subcommands) {
        HashMap map = new HashMap();
        map.put(PlatformCli.class, new CommandLine(PlatformCli.class));
        subcommands.forEach(subcommand -> map.put(subcommand.subcommandClass, new CommandLine(subcommand.subcommandClass)));
        return map;
    }

    private static void linkCommandLines(Map<Class<?>, Class<?>> parentMap, Map<Class<?>, CommandLine> commandLineMap) {
        parentMap.keySet().stream().sorted(Comparator.comparing(Class::toString)).forEachOrdered(command -> {
            CommandLine parentCommandLine = (CommandLine)commandLineMap.get(parentMap.get(command));
            if (parentCommandLine == null) {
                return;
            }
            parentCommandLine.addSubcommand(commandLineMap.get(command));
        });
    }

    private static CommandLine getRootCommandLine(Map<Class<?>, CommandLine> commandLineMap) {
        return commandLineMap.get(PlatformCli.class);
    }

    private static CommandLine buildCommandLine() {
        List<Subcommand> subcommands = PlatformCli.getSubcommands();
        Map<Class<?>, Class<?>> parentMap = PlatformCli.buildParentMap(subcommands);
        Map<Class<?>, CommandLine> commandLineMap = PlatformCli.buildCommandLines(subcommands);
        PlatformCli.linkCommandLines(parentMap, commandLineMap);
        return PlatformCli.getRootCommandLine(commandLineMap);
    }

    public static void main(String[] args) {
        System.exit(PlatformCli.buildCommandLine().execute(args));
    }

    private record Subcommand(Class<?> subcommandClass, Class<?> parentClass) {
    }
}

