/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli.parameters;

import com.swirlds.cli.utility.ParameterizedClass;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import picocli.CommandLine;

public final class OutputParameter
extends ParameterizedClass {
    private Path outputPath = Path.of("./out", new String[0]);

    private OutputParameter() {
    }

    @CommandLine.Option(names={"-o", "--out"}, description={"The location where output is written. Default = './out'. Must not exist prior to invocation."})
    private void setOutputPath(Path outputPath) {
        this.outputPath = outputPath;
    }

    public Path getOutputPath() {
        Path absoluteOut = this.outputPath.toAbsolutePath();
        if (Files.exists(absoluteOut, new LinkOption[0])) {
            throw this.buildParameterException("Output path " + absoluteOut + " already exists!");
        }
        return absoluteOut;
    }
}

