/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common;

import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.Normalizer;
import java.util.Locale;
import java.util.stream.Stream;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.Conversion;

public class CommonUtils {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static Synthesizer synthesizer;
    private static Clip clip;
    private static byte[] data;
    private static AudioFormat format;

    public static byte[] getNormalisedStringBytes(String s) {
        if (s == null) {
            return null;
        }
        return Normalizer.normalize(s, Normalizer.Form.NFD).getBytes(DEFAULT_CHARSET);
    }

    public static String getNormalisedStringFromBytes(byte[] bytes) {
        return new String(bytes, DEFAULT_CHARSET);
    }

    public static void beep() {
        CommonUtils.beep(60, 64, 20);
    }

    public static void beep(int pitch, int velocity, int duration) {
        try {
            if (synthesizer == null) {
                synthesizer = MidiSystem.getSynthesizer();
                synthesizer.open();
            }
            MidiChannel[] channels = synthesizer.getChannels();
            channels[0].noteOn(pitch, velocity);
            Thread.sleep(duration);
            channels[0].noteOff(60);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void click() {
        try {
            if (data == null) {
                data = new byte[]{0, 127};
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, false);
                clip = AudioSystem.getClip();
                clip.open(format, data, 0, data.length);
            }
            clip.start();
            while (clip.getFramePosition() < clip.getFrameLength()) {
                Thread.yield();
            }
            clip.stop();
            clip.setFramePosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void tellUserConsole(String msg) {
        System.out.println(msg);
    }

    public static void tellUserConsolePopup(String title, String msg) {
        CommonUtils.tellUserConsole("\n***** " + msg + " *****\n");
        if (!GraphicsEnvironment.isHeadless()) {
            String[] ss = msg.split("\n");
            int w = 0;
            for (String str : ss) {
                w = Math.max(w, str.length());
            }
            final JTextArea ta = new JTextArea(ss.length + 1, (int)((double)w * 0.65));
            ta.setText(msg);
            ta.setWrapStyleWord(true);
            ta.setLineWrap(true);
            ta.setCaretPosition(0);
            ta.setEditable(false);
            ta.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    Dialog dialog;
                    Window window = SwingUtilities.getWindowAncestor(ta);
                    if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                        dialog.setResizable(true);
                    }
                }
            });
            JScrollPane sp = new JScrollPane(ta);
            JOptionPane.showMessageDialog(null, sp, title, -1);
        }
    }

    public static String hex(byte[] bytes, int length) {
        if (bytes == null) {
            return "null";
        }
        CommonUtils.throwRangeInvalid("length", length, 0, bytes.length);
        return new String(Hex.encodeHex((byte[])bytes, (int)0, (int)length, (boolean)true));
    }

    public static String hex(byte[] bytes) {
        return CommonUtils.hex(bytes, bytes == null ? 0 : bytes.length);
    }

    public static byte[] unhex(String string) {
        if (string == null) {
            return null;
        }
        try {
            return Hex.decodeHex((String)string);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void throwArgNull(Object arg, String argName) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("The supplied argument '%s' cannot be null!", argName));
        }
    }

    public static void throwRangeInvalid(String name, int value, int minValue, int maxValue) {
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException(String.format("The argument '%s' should have a value between %d and %d! Value provided is %d", name, minValue, maxValue, value));
        }
    }

    public static File canonicalFile(String ... names) {
        return CommonUtils.canonicalFile(new File("."), names);
    }

    public static File canonicalFile(File start, String ... names) {
        File f = start;
        try {
            f = f.getCanonicalFile();
            for (int i = 0; i < names.length; ++i) {
                f = new File(f, names[i]).getCanonicalFile();
            }
        }
        catch (IOException e) {
            f = null;
        }
        return f;
    }

    public static String nameToAlias(String name) {
        String alias = name.toLowerCase(Locale.ROOT);
        alias = Normalizer.normalize(alias, Normalizer.Form.NFD);
        alias = alias.replaceAll("[^\\p{L}0-9]", "");
        return alias;
    }

    public static boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                CommonUtils.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    public static byte[] intToBytes(int value) {
        byte[] result = new byte[4];
        return Conversion.intToByteArray((int)value, (int)0, (byte[])result, (int)0, (int)4);
    }

    public static void hardLinkTree(File source, File destination) {
        try {
            if (!source.exists()) {
                throw new IOException(source + " does not exist or can not be accessed");
            }
            if (destination.exists()) {
                throw new IOException(destination + " already exists");
            }
            Path sourcePath = source.toPath();
            Path destinationPath = destination.toPath();
            try (Stream<Path> files = Files.walk(source.toPath(), new FileVisitOption[0]);){
                files.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(originalDirectoryPath -> {
                    Path relativeDirectoryPath = sourcePath.relativize((Path)originalDirectoryPath);
                    Path newDirectoryPath = destinationPath.resolve(relativeDirectoryPath);
                    try {
                        Files.createDirectories(newDirectoryPath, new FileAttribute[0]);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                });
            }
            files = Files.walk(source.toPath(), new FileVisitOption[0]);
            try {
                files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(originalFilePath -> {
                    Path relativeFilePath = sourcePath.relativize((Path)originalFilePath);
                    Path newFilePath = destinationPath.resolve(relativeFilePath);
                    try {
                        Files.createLink(newFilePath, originalFilePath);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                });
            }
            finally {
                if (files != null) {
                    files.close();
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    static {
        clip = null;
        data = null;
        format = null;
    }
}

