/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common;

import com.swirlds.common.EventCreationRule;
import com.swirlds.common.EventCreationRuleResponse;

public class NodeId
implements EventCreationRule {
    private boolean isMirror;
    private long id;

    public NodeId(boolean isMirror, long id) {
        this.isMirror = isMirror;
        this.id = id;
    }

    public static NodeId createMain(long id) {
        return new NodeId(false, id);
    }

    static NodeId createMirror(long id) {
        return new NodeId(true, id);
    }

    public boolean sameNetwork(NodeId nodeId) {
        return this.isMirror() == nodeId.isMirror();
    }

    private boolean equals(boolean isMirror, long id) {
        return this.isMirror() == isMirror && id == this.getId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodeId)) {
            throw new IllegalArgumentException("obj must be a NodeId object");
        }
        return this.equals((NodeId)obj);
    }

    public int hashCode() {
        return Boolean.hashCode(this.isMirror) + Long.hashCode(this.id);
    }

    public boolean equals(NodeId nodeId) {
        return this.equals(nodeId.isMirror(), nodeId.getId());
    }

    public boolean equalsMain(long id) {
        return this.equals(false, id);
    }

    public boolean equalsMirror(long id) {
        return this.equals(true, id);
    }

    public boolean isMirror() {
        return this.isMirror;
    }

    public boolean isMain() {
        return !this.isMirror;
    }

    public long getId() {
        return this.id;
    }

    public int getIdAsInt() {
        return (int)this.id;
    }

    public String toString() {
        return (this.isMirror ? "m" : "") + this.id;
    }

    @Override
    public EventCreationRuleResponse shouldCreateEvent() {
        if (this.isMain()) {
            return EventCreationRuleResponse.PASS;
        }
        return EventCreationRuleResponse.DONT_CREATE;
    }
}

