/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class ThresholdLimitingHandler<E> {
    private final long threshold;
    private final Map<Class<E>, Long> state;

    public ThresholdLimitingHandler(long threshold) {
        this.threshold = threshold;
        this.state = new ConcurrentHashMap<Class<E>, Long>();
    }

    public void handle(E element, Consumer<E> callback) {
        if (element == null) {
            throw new IllegalArgumentException("The element argument may not be a null value");
        }
        Class<E> elClass = this.resolveElementClass(element);
        long counter = this.state.compute(elClass, (k, oldValue) -> {
            if (oldValue == null) {
                return 1L;
            }
            return oldValue + 1L;
        });
        if (counter <= this.threshold && callback != null) {
            callback.accept(element);
        }
    }

    public long getCurrentThreshold(E element) {
        if (element == null) {
            throw new IllegalArgumentException("The element argument may not be a null value");
        }
        Class<E> elClass = this.resolveElementClass(element);
        this.state.putIfAbsent(elClass, 0L);
        return this.state.get(elClass);
    }

    public void reset() {
        this.state.clear();
    }

    public void reset(E element) {
        Class<E> elClass = this.resolveElementClass(element);
        this.state.remove(elClass);
    }

    private Class<E> resolveElementClass(E element) {
        Class<?> elClass = element != null ? element.getClass() : null;
        return elClass;
    }
}

