/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.bloom;

import com.swirlds.common.bloom.BloomHasher;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.io.SerializableDataOutputStream;
import java.io.IOException;
import java.util.Objects;

public class BloomFilter<T>
implements SelfSerializable {
    private static final long CLASS_ID = -1219153777646071794L;
    public static final int MAX_ARRAY_SIZE = 0x3FFFFFFF;
    private static final long BITS_PER_INT = 32L;
    private static final long BITS_PER_ARRAY = 34359738336L;
    private static final int FIRST_BIT = Integer.MIN_VALUE;
    private int hashCount;
    private BloomHasher<T> hashProvider;
    private long filterSizeInBits;
    private int[][] filter;
    private long[] hashBuffer;

    public BloomFilter() {
    }

    public BloomFilter(int hashCount, BloomHasher<T> hashProvider, long filterSizeInBits) {
        if (hashCount <= 0) {
            throw new IllegalArgumentException("hash count must be greater than 0");
        }
        if (filterSizeInBits <= 0L) {
            throw new IllegalArgumentException("filter size must be greater than 0");
        }
        this.hashCount = hashCount;
        this.hashProvider = Objects.requireNonNull(hashProvider, "null hash provider not supported");
        this.filterSizeInBits = filterSizeInBits;
        this.filter = this.createFilter();
        this.hashBuffer = new long[hashCount];
    }

    private int[][] createFilter() {
        double byteCount = Math.ceil((double)this.filterSizeInBits * 0.125);
        double intCount = Math.ceil(byteCount / 4.0);
        int arrayCount = (int)Math.ceil(intCount / 1.073741823E9);
        int[][] array = new int[arrayCount][];
        for (int arrayIndex = 0; arrayIndex < arrayCount - 1; ++arrayIndex) {
            array[arrayIndex] = new int[0x3FFFFFFF];
        }
        int lastArraySize = (int)((long)intCount - (long)((arrayCount - 1) * 0x3FFFFFFF));
        array[arrayCount - 1] = new int[lastArraySize];
        return array;
    }

    public void add(T element) {
        this.hash(element, this.hashBuffer);
        this.add(this.hashBuffer);
    }

    public void add(long[] hashes) {
        Objects.requireNonNull(hashes, "null hash array not supported");
        for (long hash : hashes) {
            this.setBit(hash);
        }
    }

    public boolean contains(T element) {
        return this.contains(this.hash(element));
    }

    public boolean contains(long[] hashes) {
        Objects.requireNonNull(hashes, "null hash array not supported");
        for (long hash : hashes) {
            if (this.isBitSet(hash)) continue;
            return false;
        }
        return true;
    }

    public long[] hash(T element) {
        long[] hashes = new long[this.hashCount];
        this.hash(element, hashes);
        return hashes;
    }

    public void hash(T element, long[] hashes) {
        Objects.requireNonNull(hashes, "null hash array not supported");
        this.hashProvider.hash(element, this.filterSizeInBits, hashes);
    }

    private static int getArrayIndex(long index) {
        return (int)(index / 34359738336L);
    }

    private static int getIntIndex(long index) {
        return (int)(index % 34359738336L / 32L);
    }

    private static int getBitIndex(long index) {
        return (int)(index % 32L);
    }

    private boolean isBitSet(long index) {
        int[] array = this.filter[BloomFilter.getArrayIndex(index)];
        int integer = array[BloomFilter.getIntIndex(index)];
        return (Integer.MIN_VALUE >>> BloomFilter.getBitIndex(index) & integer) != 0;
    }

    private void setBit(long index) {
        int[] array = this.filter[BloomFilter.getArrayIndex(index)];
        int intIndex = BloomFilter.getIntIndex(index);
        int integer = array[intIndex];
        array[intIndex] = Integer.MIN_VALUE >>> BloomFilter.getBitIndex(index) | integer;
    }

    @Override
    public long getClassId() {
        return -1219153777646071794L;
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeSerializable(this.hashProvider, true);
        out.writeInt(this.hashCount);
        out.writeLong(this.filterSizeInBits);
        for (int[] array : this.filter) {
            out.writeIntArray(array);
        }
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.hashProvider = (BloomHasher)in.readSerializable();
        this.hashCount = in.readInt();
        this.filterSizeInBits = in.readLong();
        double byteCount = Math.ceil((double)this.filterSizeInBits * 0.125);
        double intCount = Math.ceil(byteCount / 4.0);
        int arrayCount = (int)Math.ceil(intCount / 1.073741823E9);
        int lastArraySize = (int)((long)intCount - (long)((arrayCount - 1) * 0x3FFFFFFF));
        this.filter = new int[arrayCount][];
        for (int arrayIndex = 0; arrayIndex < arrayCount - 1; ++arrayIndex) {
            this.filter[arrayIndex] = in.readIntArray(0x3FFFFFFF);
        }
        this.filter[arrayCount - 1] = in.readIntArray(lastArraySize);
        this.hashBuffer = new long[this.hashCount];
    }

    @Override
    public int getVersion() {
        return 1;
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

