/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto;

import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.engine.CryptoEngine;
import com.swirlds.common.crypto.internal.CryptographySettings;

public final class CryptoFactory {
    private static volatile Cryptography cryptography;
    private static volatile CryptographySettings engineSettings;

    private CryptoFactory() {
        throw new UnsupportedOperationException();
    }

    public static synchronized void configure(CryptographySettings settings) {
        engineSettings = settings;
        if (cryptography != null && cryptography instanceof CryptoEngine) {
            ((CryptoEngine)cryptography).setSettings(engineSettings);
        }
    }

    public static synchronized Cryptography getInstance() {
        if (cryptography == null) {
            cryptography = new CryptoEngine(engineSettings);
        }
        return cryptography;
    }

    static {
        engineSettings = CryptographySettings.getDefaultSettings();
    }
}

