/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.CryptographyException;
import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.HashBuilder;
import com.swirlds.common.crypto.Message;
import com.swirlds.common.crypto.SerializableHashable;
import com.swirlds.common.crypto.SignatureType;
import com.swirlds.common.crypto.TransactionSignature;
import com.swirlds.common.crypto.VerificationStatus;
import com.swirlds.common.crypto.engine.AsyncDigestHandler;
import com.swirlds.common.crypto.engine.AsyncVerificationHandler;
import com.swirlds.common.crypto.engine.DelegatingVerificationProvider;
import com.swirlds.common.crypto.engine.DigestProvider;
import com.swirlds.common.crypto.engine.EcdsaSecp256k1VerificationProvider;
import com.swirlds.common.crypto.engine.Ed25519VerificationProvider;
import com.swirlds.common.crypto.engine.IntakeDispatcher;
import com.swirlds.common.crypto.engine.MerkleInternalDigestProvider;
import com.swirlds.common.crypto.engine.OperationProvider;
import com.swirlds.common.crypto.engine.RunningHashProvider;
import com.swirlds.common.crypto.engine.SerializationDigestProvider;
import com.swirlds.common.crypto.engine.WrappingLambdaFuture;
import com.swirlds.common.crypto.internal.CryptographySettings;
import com.swirlds.common.futures.WaitingFuture;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.hash.MerkleHashBuilder;
import com.swirlds.common.merkle.utility.MerkleConstants;
import com.swirlds.logging.LogMarker;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CryptoEngine
implements Cryptography {
    public static final String THREAD_COMPONENT_NAME = "adv crypto";
    private static final Logger LOG = LogManager.getLogger(CryptoEngine.class);
    private final SerializationDigestProvider serializationDigestProvider;
    private final MerkleInternalDigestProvider merkleInternalDigestProvider;
    private final RunningHashProvider runningHashProvider;
    private final MerkleHashBuilder merkleHashBuilder;
    private final DigestProvider digestProvider;
    private final Ed25519VerificationProvider ed25519VerificationProvider;
    private final EcdsaSecp256k1VerificationProvider ecdsaSecp256k1VerificationProvider;
    private final DelegatingVerificationProvider delegatingVerificationProvider;
    private final int availableCpuCount;
    private volatile IntakeDispatcher<TransactionSignature, DelegatingVerificationProvider, AsyncVerificationHandler> verificationDispatcher;
    private volatile IntakeDispatcher<Message, DigestProvider, AsyncDigestHandler> digestDispatcher;
    private volatile BlockingQueue<List<TransactionSignature>> verificationQueue;
    private volatile BlockingQueue<List<Message>> digestQueue;
    private volatile CryptographySettings settings;
    private Map<DigestType, Hash> nullHashes;

    public CryptoEngine() {
        this(CryptographySettings.getDefaultSettings());
    }

    public CryptoEngine(CryptographySettings settings) {
        this.settings = settings;
        this.availableCpuCount = Runtime.getRuntime().availableProcessors();
        this.digestProvider = new DigestProvider();
        this.ed25519VerificationProvider = new Ed25519VerificationProvider();
        this.ecdsaSecp256k1VerificationProvider = new EcdsaSecp256k1VerificationProvider();
        this.delegatingVerificationProvider = new DelegatingVerificationProvider(this.ed25519VerificationProvider, this.ecdsaSecp256k1VerificationProvider);
        this.serializationDigestProvider = new SerializationDigestProvider();
        this.merkleInternalDigestProvider = new MerkleInternalDigestProvider();
        this.runningHashProvider = new RunningHashProvider();
        this.merkleHashBuilder = new MerkleHashBuilder(this, settings.computeCpuDigestThreadCount());
        this.applySettings();
        this.buildNullHashes();
    }

    private static AsyncVerificationHandler verificationHandler(OperationProvider<TransactionSignature, Void, Boolean, ?, SignatureType> provider, List<TransactionSignature> workItems) {
        return new AsyncVerificationHandler(workItems, provider);
    }

    private static TransactionSignature wrap(byte[] data, byte[] signature, byte[] publicKey, SignatureType signatureType) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("data");
        }
        if (signature == null || signature.length == 0) {
            throw new IllegalArgumentException("signature");
        }
        if (publicKey == null || publicKey.length == 0) {
            throw new IllegalArgumentException("publicKey");
        }
        ByteBuffer buffer = ByteBuffer.allocate(data.length + signature.length + publicKey.length);
        int sigOffset = data.length;
        int pkOffset = sigOffset + signature.length;
        buffer.put(data).put(signature).put(publicKey);
        return new TransactionSignature(buffer.array(), sigOffset, signature.length, pkOffset, publicKey.length, 0, data.length, signatureType);
    }

    private static Hash digestSyncInternal(Message message, DigestProvider provider, WaitingFuture<Void> future) {
        Hash hash;
        try {
            hash = (Hash)provider.compute(message, message.getDigestType());
            message.setHash(hash);
        }
        catch (NoSuchAlgorithmException ex) {
            message.setFuture(future);
            throw new CryptographyException(ex, LogMarker.EXCEPTION);
        }
        message.setFuture(future);
        return hash;
    }

    private static boolean verifySyncInternal(TransactionSignature signature, OperationProvider<TransactionSignature, Void, Boolean, ?, SignatureType> provider, WaitingFuture<Void> future) {
        boolean isValid;
        try {
            isValid = provider.compute(signature, signature.getSignatureType());
            signature.setSignatureStatus(isValid ? VerificationStatus.VALID : VerificationStatus.INVALID);
            signature.setFuture(future);
        }
        catch (NoSuchAlgorithmException ex) {
            signature.setFuture(future);
            throw new CryptographyException(ex, LogMarker.EXCEPTION);
        }
        return isValid;
    }

    public boolean isOpenCLAvailable() {
        return false;
    }

    public boolean isGpuAvailable() {
        return false;
    }

    public synchronized CryptographySettings getSettings() {
        return this.settings;
    }

    public synchronized void setSettings(CryptographySettings settings) {
        this.settings = settings;
        this.applySettings();
    }

    public int getAvailableCpuCount() {
        return this.availableCpuCount;
    }

    @Override
    public void digestAsync(Message message) {
        try {
            this.digestQueue.put(Collections.singletonList(message));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void digestAsync(List<Message> messages) {
        try {
            this.digestQueue.put(messages);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Future<Hash> digestAsync(byte[] message, DigestType digestType) {
        Message wrappedMessage = new Message(message, digestType);
        try {
            this.digestQueue.put(Collections.singletonList(wrappedMessage));
            return new WrappingLambdaFuture(() -> {
                try {
                    return wrappedMessage.waitForFuture();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }, wrappedMessage::getHash);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CryptographyException(ex, LogMarker.TESTING_EXCEPTIONS);
        }
    }

    @Override
    public Hash digestSync(Message message) {
        DigestProvider provider = new DigestProvider();
        WaitingFuture<Void> future = new WaitingFuture<Void>();
        future.done(null);
        return CryptoEngine.digestSyncInternal(message, provider, future);
    }

    @Override
    public void digestSync(List<Message> messages) {
        WaitingFuture<Void> future = new WaitingFuture<Void>();
        future.done(null);
        for (Message message : messages) {
            CryptoEngine.digestSyncInternal(message, this.digestProvider, future);
        }
    }

    @Override
    public Hash digestSync(byte[] message, DigestType digestType) {
        return this.digestSyncInternal(message, digestType, this.digestProvider);
    }

    @Override
    public Hash digestSync(SelfSerializable serializable, DigestType digestType) {
        try {
            return (Hash)this.serializationDigestProvider.compute(serializable, digestType);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptographyException(ex, LogMarker.EXCEPTION);
        }
    }

    @Override
    public Hash digestSync(SerializableHashable serializableHashable, DigestType digestType, boolean setHash) {
        try {
            Hash hash = (Hash)this.serializationDigestProvider.compute(serializableHashable, digestType);
            if (setHash) {
                serializableHashable.setHash(hash);
            }
            return hash;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptographyException(ex, LogMarker.EXCEPTION);
        }
    }

    @Override
    public Hash digestTreeSync(MerkleNode root, DigestType digestType) {
        return this.merkleHashBuilder.digestTreeSync(root);
    }

    @Override
    public Future<Hash> digestTreeAsync(MerkleNode root, DigestType digestType) {
        return this.merkleHashBuilder.digestTreeAsync(root);
    }

    private void buildNullHashes() {
        this.nullHashes = new HashMap<DigestType, Hash>();
        for (DigestType digestType : DigestType.values()) {
            HashBuilder hb = new HashBuilder(digestType);
            this.nullHashes.put(digestType, hb.build());
        }
    }

    @Override
    public Hash getNullHash(DigestType digestType) {
        return this.nullHashes.get((Object)digestType);
    }

    @Override
    public Hash digestSync(MerkleInternal node, List<Hash> childHashes, boolean setHash) {
        try {
            Hash hash = this.merkleInternalDigestProvider.compute(node, childHashes, MerkleConstants.MERKLE_DIGEST_TYPE);
            if (setHash) {
                node.setHash(hash);
            }
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e, LogMarker.EXCEPTION);
        }
    }

    @Override
    public void verifyAsync(TransactionSignature signature) {
        try {
            this.verificationQueue.put(Collections.singletonList(signature));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void verifyAsync(List<TransactionSignature> signatures) {
        try {
            this.verificationQueue.put(signatures);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Future<Boolean> verifyAsync(byte[] data, byte[] signature, byte[] publicKey, SignatureType signatureType) {
        TransactionSignature wrappedSignature = CryptoEngine.wrap(data, signature, publicKey, signatureType);
        try {
            this.verificationQueue.put(Collections.singletonList(wrappedSignature));
            return new WrappingLambdaFuture(() -> {
                try {
                    return wrappedSignature.waitForFuture();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }, () -> wrappedSignature.getSignatureStatus() == VerificationStatus.VALID);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CryptographyException(ex, LogMarker.TESTING_EXCEPTIONS);
        }
    }

    @Override
    public boolean verifySync(TransactionSignature signature) {
        WaitingFuture<Void> future = new WaitingFuture<Void>();
        future.done(null);
        if (signature.getSignatureType() == SignatureType.ECDSA_SECP256K1) {
            return CryptoEngine.verifySyncInternal(signature, this.ecdsaSecp256k1VerificationProvider, future);
        }
        return CryptoEngine.verifySyncInternal(signature, this.ed25519VerificationProvider, future);
    }

    @Override
    public boolean verifySync(List<TransactionSignature> signatures) {
        WaitingFuture<Void> future = new WaitingFuture<Void>();
        future.done(null);
        boolean finalOutcome = true;
        Iterator<TransactionSignature> iterator = signatures.iterator();
        while (iterator.hasNext()) {
            TransactionSignature signature;
            OperationProvider provider = (signature = iterator.next()).getSignatureType() == SignatureType.ECDSA_SECP256K1 ? this.ecdsaSecp256k1VerificationProvider : this.ed25519VerificationProvider;
            if (CryptoEngine.verifySyncInternal(signature, provider, future)) continue;
            finalOutcome = false;
        }
        return finalOutcome;
    }

    @Override
    public boolean verifySync(byte[] data, byte[] signature, byte[] publicKey, SignatureType signatureType) {
        if (signatureType == SignatureType.ECDSA_SECP256K1) {
            return this.ecdsaSecp256k1VerificationProvider.compute(data, signature, publicKey, signatureType);
        }
        return this.ed25519VerificationProvider.compute(data, signature, publicKey, signatureType);
    }

    @Override
    public Hash calcRunningHash(Hash runningHash, Hash newHashToAdd, DigestType digestType) {
        try {
            return this.runningHashProvider.compute(runningHash, newHashToAdd, digestType);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e, LogMarker.EXCEPTION);
        }
    }

    protected synchronized void applySettings() {
        if (this.verificationDispatcher != null) {
            this.verificationDispatcher.shutdown();
            this.verificationDispatcher = null;
        }
        if (this.digestDispatcher != null) {
            this.digestDispatcher.shutdown();
            this.digestDispatcher = null;
        }
        BlockingQueue<List<TransactionSignature>> oldVerifierQueue = this.verificationQueue;
        this.verificationQueue = new LinkedBlockingQueue<List<TransactionSignature>>(this.settings.getCpuVerifierQueueSize());
        BlockingQueue<List<Message>> oldDigestQueue = this.digestQueue;
        this.digestQueue = new LinkedBlockingQueue<List<Message>>(this.settings.getCpuDigestQueueSize());
        if (oldVerifierQueue != null && oldVerifierQueue.size() > 0) {
            this.verificationQueue.addAll(oldVerifierQueue);
        }
        if (oldDigestQueue != null && oldDigestQueue.size() > 0) {
            this.digestQueue.addAll(oldDigestQueue);
        }
        this.verificationDispatcher = new IntakeDispatcher<TransactionSignature, DelegatingVerificationProvider, AsyncVerificationHandler>(TransactionSignature.class, this.verificationQueue, this.delegatingVerificationProvider, this.settings.computeCpuVerifierThreadCount(), CryptoEngine::verificationHandler);
        this.digestDispatcher = new IntakeDispatcher<Message, DigestProvider, AsyncDigestHandler>(Message.class, this.digestQueue, this.digestProvider, this.settings.computeCpuDigestThreadCount(), this::digestHandler);
    }

    private AsyncDigestHandler digestHandler(DigestProvider provider, List<Message> workItems) {
        return new AsyncDigestHandler(workItems, provider);
    }

    private Hash digestSyncInternal(byte[] message, DigestType digestType, DigestProvider provider) {
        try {
            return provider.compute(message, digestType);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptographyException(ex, LogMarker.EXCEPTION);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

