/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io;

import com.swirlds.common.CommonUtils;
import com.swirlds.common.io.BadIOException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongArray;

public class ExtendedDataInputStream
extends DataInputStream {
    public ExtendedDataInputStream(InputStream in) {
        super(in);
    }

    public byte[] readByteArray(int maxLength, boolean readChecksum) throws IOException {
        int checksum;
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        if (readChecksum && (checksum = this.readInt()) != 101 - len) {
            throw new BadIOException("SerializableDataInputStream tried to create array of length " + len + " with wrong checksum.");
        }
        this.checkLengthLimit(len, maxLength);
        byte[] bytes = new byte[len];
        this.readFully(bytes);
        return bytes;
    }

    public byte[] readByteArray(int maxLength) throws IOException {
        return this.readByteArray(maxLength, false);
    }

    public int[] readIntArray(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.readInt();
        }
        return data;
    }

    public List<Integer> readIntList(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        ArrayList<Integer> data = new ArrayList<Integer>(len);
        for (int i = 0; i < len; ++i) {
            data.add(this.readInt());
        }
        return data;
    }

    public long[] readLongArray(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.readLong();
        }
        return data;
    }

    public List<Long> readLongList(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        ArrayList<Long> data = new ArrayList<Long>(len);
        for (int i = 0; i < len; ++i) {
            data.add(this.readLong());
        }
        return data;
    }

    public List<Boolean> readBooleanList(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        ArrayList<Boolean> data = new ArrayList<Boolean>(len);
        for (int i = 0; i < len; ++i) {
            data.add(this.readBoolean());
        }
        return data;
    }

    public float[] readFloatArray(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        float[] data = new float[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.readFloat();
        }
        return data;
    }

    public List<Float> readFloatList(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        ArrayList<Float> data = new ArrayList<Float>(len);
        for (int i = 0; i < len; ++i) {
            data.add(Float.valueOf(this.readFloat()));
        }
        return data;
    }

    public double[] readDoubleArray(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.readDouble();
        }
        return data;
    }

    public List<Double> readDoubleList(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        ArrayList<Double> data = new ArrayList<Double>(len);
        for (int i = 0; i < len; ++i) {
            data.add(this.readDouble());
        }
        return data;
    }

    public String[] readStringArray(int maxLength, int maxStringLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        String[] data = new String[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.readNormalisedString(maxStringLength);
        }
        return data;
    }

    public List<String> readStringList(int maxLength, int maxStringLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        ArrayList<String> data = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            data.add(this.readNormalisedString(maxStringLength));
        }
        return data;
    }

    public AtomicLongArray readAtomicLongArray(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        AtomicLongArray data = new AtomicLongArray(len);
        for (int i = 0; i < len; ++i) {
            data.set(i, this.readLong());
        }
        return data;
    }

    public Instant readInstant() throws IOException {
        long epochSecond = this.readLong();
        if (epochSecond == Long.MIN_VALUE) {
            return null;
        }
        long nanos = this.readLong();
        if (nanos < 0L || nanos > 999999999L) {
            throw new IOException("Instant.nanosecond is not within the allowed range!");
        }
        return Instant.ofEpochSecond(epochSecond, nanos);
    }

    public String readNormalisedString(int maxLength) throws IOException {
        byte[] data = this.readByteArray(maxLength);
        if (data == null) {
            return null;
        }
        return CommonUtils.getNormalisedStringFromBytes(data);
    }

    protected void checkLengthLimit(int length, int maxLength) throws IOException {
        if (length > maxLength) {
            throw new IOException(String.format("The input stream provided a length of %d for the list/array which exceeds the maxLength of %d", length, maxLength));
        }
    }
}

