/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io;

import com.swirlds.common.CommonUtils;
import com.swirlds.common.constructable.ConstructableRegistry;
import com.swirlds.common.io.ClassNotFoundException;
import com.swirlds.common.io.ExtendedDataInputStream;
import com.swirlds.common.io.InvalidVersionException;
import com.swirlds.common.io.NotSerializableException;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class SerializableDataInputStream
extends ExtendedDataInputStream {
    private int protocolVersion = 1;

    public SerializableDataInputStream(InputStream in) {
        super(in);
    }

    public void readProtocolVersion() throws IOException {
        this.protocolVersion = this.readInt();
    }

    public <T extends SelfSerializable> T readSerializable() throws IOException {
        return (T)this.readSerializable(true, SerializableDataInputStream::registryConstructor);
    }

    public <T extends SelfSerializable> T readSerializable(boolean readClassId, Supplier<T> serializableConstructor) throws IOException {
        CommonUtils.throwArgNull(serializableConstructor, "serializableConstructor");
        return (T)this.readSerializable(readClassId, (Long id) -> (SelfSerializable)serializableConstructor.get());
    }

    protected void validateVersion(SerializableDet object, int version) {
        if (version < object.getMinimumSupportedVersion() || version > object.getVersion()) {
            throw new InvalidVersionException(version, object);
        }
    }

    private <T extends SelfSerializable> T readSerializable(boolean readClassId, Function<Long, T> serializableConstructor) throws IOException {
        Long classId = null;
        if (readClassId && (classId = Long.valueOf(this.readLong())) == Long.MIN_VALUE) {
            return null;
        }
        int version = this.readInt();
        if (version == Integer.MIN_VALUE) {
            return null;
        }
        SelfSerializable serializable = (SelfSerializable)serializableConstructor.apply(classId);
        this.validateVersion(serializable, version);
        serializable.deserialize(this, version);
        return (T)serializable;
    }

    public <T extends SelfSerializable> void readSerializableIterableWithSize(int maxSize, Consumer<T> callback) throws IOException {
        int size = this.readInt();
        this.checkLengthLimit(size, maxSize);
        this.readSerializableIterableWithSize(size, true, SerializableDataInputStream::registryConstructor, callback);
    }

    private <T extends SelfSerializable> void readSerializableIterableWithSize(int size, boolean readClassId, Function<Long, T> serializableConstructor, Consumer<T> callback) throws IOException {
        if (serializableConstructor == null) {
            throw new IllegalArgumentException("serializableConstructor is null");
        }
        if (size == 0) {
            return;
        }
        boolean allSameClass = this.readBoolean();
        boolean classIdVersionRead = false;
        Integer version = null;
        Long classId = null;
        for (int i = 0; i < size; ++i) {
            if (!allSameClass) {
                callback.accept(this.readSerializable(readClassId, serializableConstructor));
                continue;
            }
            boolean isNull = this.readBoolean();
            if (isNull) {
                callback.accept(null);
                continue;
            }
            if (!classIdVersionRead) {
                if (readClassId) {
                    classId = this.readLong();
                }
                version = this.readInt();
                classIdVersionRead = true;
            }
            SelfSerializable serializable = (SelfSerializable)serializableConstructor.apply(classId);
            serializable.deserialize(this, version);
            callback.accept(serializable);
        }
    }

    public <T extends SelfSerializable> List<T> readSerializableList(int maxListSize) throws IOException {
        return this.readSerializableList(maxListSize, true, SerializableDataInputStream::registryConstructor);
    }

    public <T extends SelfSerializable> List<T> readSerializableList(int maxListSize, boolean readClassId, Supplier<T> serializableConstructor) throws IOException {
        CommonUtils.throwArgNull(serializableConstructor, "serializableConstructor");
        return this.readSerializableList(maxListSize, readClassId, (Long id) -> (SelfSerializable)serializableConstructor.get());
    }

    public <T extends SelfSerializable> T[] readSerializableArray(Function<Integer, T[]> arrayConstructor, int maxListSize, boolean readClassId) throws IOException {
        List<SelfSerializable> list = this.readSerializableList(maxListSize, readClassId, SerializableDataInputStream::registryConstructor);
        if (list == null) {
            return null;
        }
        return list.toArray((SelfSerializable[])arrayConstructor.apply(list.size()));
    }

    public <T extends SelfSerializable> T[] readSerializableArray(Function<Integer, T[]> arrayConstructor, int maxListSize, boolean readClassId, Supplier<T> serializableConstructor) throws IOException {
        List<SelfSerializable> list = this.readSerializableList(maxListSize, readClassId, serializableConstructor);
        if (list == null) {
            return null;
        }
        return list.toArray((SelfSerializable[])arrayConstructor.apply(list.size()));
    }

    private <T extends SelfSerializable> List<T> readSerializableList(int maxListSize, boolean readClassId, Function<Long, T> serializableConstructor) throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        this.checkLengthLimit(length, maxListSize);
        ArrayList list = new ArrayList(length);
        if (length == 0) {
            return list;
        }
        this.readSerializableIterableWithSize(length, readClassId, serializableConstructor, list::add);
        return list;
    }

    private static <T extends SelfSerializable> T registryConstructor(long classId) throws NotSerializableException {
        SelfSerializable rc = (SelfSerializable)ConstructableRegistry.createObject(classId);
        if (rc == null) {
            throw new ClassNotFoundException(classId);
        }
        return (T)rc;
    }
}

