/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle;

import com.swirlds.common.FastCopyable;
import com.swirlds.common.crypto.Hashable;
import com.swirlds.common.io.SerializableDet;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.io.SerializationStrategy;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.MerkleRouteFactory;
import com.swirlds.common.merkle.route.MerkleRouteIterator;
import java.util.Set;
import java.util.function.Consumer;

public interface MerkleNode
extends FastCopyable,
Hashable,
SerializableDet {
    public boolean isLeaf();

    default public boolean isInternal() {
        return !this.isLeaf();
    }

    default public boolean hasCustomReconnectView() {
        return false;
    }

    public Set<SerializationStrategy> supportedSerialization(int var1);

    default public MerkleLeaf asLeaf() {
        return (MerkleLeaf)this.cast();
    }

    default public MerkleInternal asInternal() {
        return (MerkleInternal)this.cast();
    }

    default public <T extends MerkleNode> T cast() {
        return (T)this;
    }

    public MerkleRoute getRoute();

    public void setRoute(MerkleRoute var1);

    default public MerkleNode getNodeAtRoute(MerkleRoute route) {
        return new MerkleRouteIterator(this, route).getLast();
    }

    default public MerkleNode getNodeAtRoute(int ... steps) {
        return this.getNodeAtRoute(MerkleRouteFactory.buildRoute(steps));
    }

    public void incrementReferenceCount();

    public void decrementReferenceCount();

    public int getReferenceCount();

    public MerkleNode copy();

    default public <T extends MerkleNode> MerkleIterator<T> treeIterator() {
        return new MerkleIterator(this);
    }

    default public void forEachNode(Consumer<MerkleNode> operation) {
        this.treeIterator().forEachRemaining(operation);
    }
}

