/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.copy;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.io.SerializationStrategy;
import java.util.function.Predicate;

public final class MerkleInitialize {
    private MerkleInitialize() {
    }

    private static boolean deserializationFilter(MerkleNode node) {
        return !node.isLeaf() && !node.supportedSerialization(node.getVersion()).contains((Object)SerializationStrategy.SELF_SERIALIZATION);
    }

    private static boolean externalDeserializationFilter(MerkleNode node) {
        return !node.isLeaf() && !node.supportedSerialization(node.getVersion()).contains((Object)SerializationStrategy.SELF_SERIALIZATION) && !node.supportedSerialization(node.getVersion()).contains((Object)SerializationStrategy.EXTERNAL_SELF_SERIALIZATION);
    }

    private static boolean copyFilter(MerkleNode node) {
        return !node.isLeaf();
    }

    public static void initializeTreeAfterDeserialization(MerkleNode root) {
        MerkleInitialize.initializeWithFilter(root, MerkleInitialize::deserializationFilter);
    }

    public static void initializeTreeAfterExternalDeserialization(MerkleNode root) {
        MerkleInitialize.initializeWithFilter(root, MerkleInitialize::externalDeserializationFilter);
    }

    public static void initializeTreeAfterCopy(MerkleNode root) {
        MerkleInitialize.initializeWithFilter(root, MerkleInitialize::copyFilter);
    }

    private static void initializeWithFilter(MerkleNode root, Predicate<MerkleNode> filter) {
        if (root == null) {
            return;
        }
        Predicate<MerkleInternal> descendantFilter = filter::test;
        root.treeIterator().setFilter(filter).setDescendantFilter(descendantFilter).forEachRemaining(node -> ((MerkleInternal)node).initialize());
    }
}

