/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.io;

import com.swirlds.common.constructable.ConstructableRegistry;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.io.ClassNotFoundException;
import com.swirlds.common.io.ExternalSelfSerializable;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.copy.MerkleInitialize;
import com.swirlds.common.merkle.exceptions.IllegalChildCountException;
import com.swirlds.common.merkle.io.MerkleSerializationException;
import com.swirlds.common.merkle.io.SerializationStrategy;
import com.swirlds.common.merkle.io.internal.MerkleTreeSerializationOptions;
import com.swirlds.common.merkle.io.internal.PartiallyConstructedMerkleInternal;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;

public class MerkleDataInputStream
extends SerializableDataInputStream {
    private final File externalDirectory;
    private final Queue<PartiallyConstructedMerkleInternal> internalNodes;
    private MerkleNode root;

    public MerkleDataInputStream(InputStream in) {
        this(in, null);
    }

    public MerkleDataInputStream(InputStream in, File externalDirectory) {
        super(in);
        if (!(externalDirectory == null || externalDirectory.exists() && externalDirectory.isDirectory())) {
            throw new IllegalArgumentException("invalid external directory " + externalDirectory.getAbsolutePath());
        }
        this.externalDirectory = externalDirectory;
        this.internalNodes = new LinkedList<PartiallyConstructedMerkleInternal>();
    }

    private void addToParent(MerkleNode child) {
        if (this.internalNodes.size() == 0) {
            this.root = child;
        } else {
            PartiallyConstructedMerkleInternal nextParent = this.internalNodes.peek();
            nextParent.addChild(child);
            if (nextParent.hasAllChildren()) {
                nextParent.finishConstruction();
                this.internalNodes.remove();
            }
        }
    }

    private void finishReadingLeaf(MerkleTreeSerializationOptions options, MerkleLeaf node, int version) throws IOException {
        if (options.isExternal() && node.supportedSerialization(version).contains((Object)SerializationStrategy.EXTERNAL_SELF_SERIALIZATION)) {
            Hash hash = (Hash)this.readSerializable();
            ((ExternalSelfSerializable)((Object)node)).deserializeExternal(this, this.externalDirectory, hash, version);
        } else if (node.supportedSerialization(version).contains((Object)SerializationStrategy.SELF_SERIALIZATION)) {
            node.deserialize(this, version);
        } else {
            throw new MerkleSerializationException("Illegal deserialization strategy requested", node);
        }
        this.addToParent(node);
    }

    private void finishReadingInternal(MerkleTreeSerializationOptions options, MerkleInternal node, int version) throws IOException {
        if (options.isExternal() && node.supportedSerialization(version).contains((Object)SerializationStrategy.EXTERNAL_SELF_SERIALIZATION)) {
            Hash hash = (Hash)this.readSerializable();
            ((ExternalSelfSerializable)((Object)node)).deserializeExternal(this, this.externalDirectory, hash, version);
            this.addToParent(node);
        } else if (node.supportedSerialization(version).contains((Object)SerializationStrategy.SELF_SERIALIZATION)) {
            ((SelfSerializable)((Object)node)).deserialize(this, version);
            this.addToParent(node);
        } else if (node.supportedSerialization(version).contains((Object)SerializationStrategy.DEFAULT_MERKLE_INTERNAL)) {
            int childCount = this.readInt();
            if (childCount < node.getMinimumChildCount(version) || childCount > node.getMaximumChildCount(version)) {
                throw new IllegalChildCountException(node.getClassId(), version, node.getMinimumChildCount(version), node.getMaximumChildCount(version), childCount);
            }
            this.addToParent(node);
            if (childCount > 0) {
                this.internalNodes.add(new PartiallyConstructedMerkleInternal(node, version, childCount));
            }
        } else {
            throw new MerkleSerializationException("Illegal deserialization strategy requested", node);
        }
    }

    private void readNextNode(MerkleTreeSerializationOptions options) throws IOException {
        long classId = this.readLong();
        if (classId == Long.MIN_VALUE) {
            this.addToParent(null);
            return;
        }
        MerkleNode node = (MerkleNode)ConstructableRegistry.createObject(classId);
        if (node == null) {
            throw new ClassNotFoundException(classId);
        }
        int classVersion = this.readInt();
        this.validateVersion(node, classVersion);
        if (node.isLeaf()) {
            this.finishReadingLeaf(options, node.asLeaf(), classVersion);
        } else {
            this.finishReadingInternal(options, node.asInternal(), classVersion);
        }
        if (options.getWriteHashes()) {
            Hash hash = this.readSerializable(false, Hash::new);
            if (!node.isSelfHashing()) {
                node.setHash(hash);
            }
        }
    }

    public <T extends MerkleNode> T readMerkleTree(int maxNumberOfNodes) throws IOException {
        int merkleVersion = this.readInt();
        if (merkleVersion != 2) {
            throw new MerkleSerializationException("Unhandled merkle version " + merkleVersion);
        }
        MerkleTreeSerializationOptions options = this.readSerializable(false, MerkleTreeSerializationOptions::new);
        boolean rootIsNull = this.readBoolean();
        if (rootIsNull) {
            return null;
        }
        int nodeCount = 0;
        while (this.internalNodes.size() > 0 || this.root == null) {
            if (++nodeCount > maxNumberOfNodes) {
                throw new MerkleSerializationException("Node count exceeds maximum value of " + maxNumberOfNodes + ".");
            }
            this.readNextNode(options);
        }
        if (options.isExternal()) {
            MerkleInitialize.initializeTreeAfterExternalDeserialization(this.root);
        } else {
            MerkleInitialize.initializeTreeAfterDeserialization(this.root);
        }
        return this.root.cast();
    }
}

