/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.io;

import com.swirlds.common.io.ExternalSelfSerializable;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDataOutputStream;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.io.MerkleSerializationException;
import com.swirlds.common.merkle.io.SerializationStrategy;
import com.swirlds.common.merkle.io.internal.MerkleTreeSerializationOptions;
import com.swirlds.common.merkle.iterators.MerkleIterationOrder;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Predicate;

public class MerkleDataOutputStream
extends SerializableDataOutputStream {
    private final MerkleTreeSerializationOptions options = MerkleTreeSerializationOptions.defaults();
    private File externalDirectory;

    public MerkleDataOutputStream(OutputStream out) {
        super(out);
    }

    public boolean isExternal() {
        return this.options.isExternal();
    }

    public MerkleDataOutputStream setExternal(boolean external) {
        this.options.setExternal(external);
        return this;
    }

    public boolean getWriteHashes() {
        return this.options.getWriteHashes();
    }

    public MerkleDataOutputStream setWriteHashes(boolean writeHashes) {
        this.options.setWriteHashes(writeHashes);
        return this;
    }

    public File getExternalDirectory() {
        return this.externalDirectory;
    }

    public MerkleDataOutputStream setExternalDirectory(File externalDirectory) {
        if (externalDirectory != null && !externalDirectory.exists() && externalDirectory.isDirectory()) {
            throw new IllegalArgumentException("invalid external directory " + externalDirectory.getAbsolutePath());
        }
        this.externalDirectory = externalDirectory;
        return this;
    }

    private void writeExternalSelfSerializableNode(MerkleNode node) throws IOException {
        this.writeClassIdVersion(node, true);
        this.writeSerializable(node.getHash(), true);
        ((ExternalSelfSerializable)((Object)node)).serializeExternal(this, this.externalDirectory);
    }

    private void writeSerializableNode(MerkleNode node) throws IOException {
        this.writeSerializable((SelfSerializable)((Object)node), true);
    }

    private void writeDefaultInternalNode(MerkleInternal node) throws IOException {
        this.writeLong(node.getClassId());
        this.writeInt(node.getVersion());
        this.writeInt(node.getNumberOfChildren());
    }

    private void writeInternal(MerkleInternal node) throws IOException {
        int version = node.getVersion();
        if (this.options.isExternal() && node.supportedSerialization(version).contains((Object)SerializationStrategy.EXTERNAL_SELF_SERIALIZATION)) {
            this.writeExternalSelfSerializableNode(node);
        } else if (node.supportedSerialization(version).contains((Object)SerializationStrategy.SELF_SERIALIZATION)) {
            this.writeSerializable((SelfSerializable)node.cast(), true);
        } else if (node.supportedSerialization(version).contains((Object)SerializationStrategy.DEFAULT_MERKLE_INTERNAL)) {
            this.writeDefaultInternalNode(node);
        } else {
            throw new MerkleSerializationException("illegal serialization strategy requested", node);
        }
    }

    private void writeLeaf(MerkleLeaf node) throws IOException {
        int version = node.getVersion();
        if (this.options.isExternal() && node.supportedSerialization(version).contains((Object)SerializationStrategy.EXTERNAL_SELF_SERIALIZATION)) {
            this.writeExternalSelfSerializableNode(node);
        } else if (node.supportedSerialization(version).contains((Object)SerializationStrategy.SELF_SERIALIZATION)) {
            this.writeSerializableNode(node);
        } else {
            throw new MerkleSerializationException("illegal serialization strategy requested", node);
        }
    }

    private void writeNull() throws IOException {
        this.writeSerializable(null, true);
    }

    public void writeMerkleTree(MerkleNode root) throws IOException {
        this.writeInt(2);
        this.writeSerializable(this.options, false);
        this.writeBoolean(root == null);
        if (root == null) {
            return;
        }
        Predicate<MerkleInternal> descendantFilter = this.options.isExternal() ? node -> !node.supportedSerialization(node.getVersion()).contains((Object)SerializationStrategy.SELF_SERIALIZATION) && !node.supportedSerialization(node.getVersion()).contains((Object)SerializationStrategy.EXTERNAL_SELF_SERIALIZATION) : node -> !node.supportedSerialization(node.getVersion()).contains((Object)SerializationStrategy.SELF_SERIALIZATION);
        MerkleIterator it = root.treeIterator().setOrder(MerkleIterationOrder.BREADTH_FIRST).setDescendantFilter(descendantFilter).ignoreNull(false);
        while (it.hasNext()) {
            MerkleNode node2 = (MerkleNode)it.next();
            if (node2 == null) {
                this.writeNull();
            } else if (node2.isLeaf()) {
                this.writeLeaf(node2.asLeaf());
            } else {
                this.writeInternal(node2.asInternal());
            }
            if (node2 == null || !this.options.getWriteHashes()) continue;
            this.writeSerializable(node2.getHash(), false);
        }
    }
}

