/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.internal;

import com.swirlds.common.crypto.Hash;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.io.SerializableDataOutputStream;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import java.io.IOException;
import java.util.List;

public class InternalDataLesson<T>
implements SelfSerializable {
    private static final long CLASS_ID = -5229074267448254303L;
    private TeacherTreeView<T> teacherTreeView;
    private LearnerTreeView<T> learnerTreeView;
    private T internal;
    private List<Hash> queries;

    public InternalDataLesson() {
    }

    public InternalDataLesson(TeacherTreeView<T> teacherTreeView, T internal) {
        this.teacherTreeView = teacherTreeView;
        this.internal = internal;
    }

    public InternalDataLesson(LearnerTreeView<T> learnerTreeView) {
        this.learnerTreeView = learnerTreeView;
    }

    public T getInternal() {
        return this.internal;
    }

    public List<Hash> getQueries() {
        return this.queries;
    }

    @Override
    public long getClassId() {
        return -5229074267448254303L;
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        this.teacherTreeView.serializeInternal(out, this.internal);
        out.writeSerializableList(this.teacherTreeView.getChildHashes(this.internal), false, true);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.internal = this.learnerTreeView.deserializeInternal(in);
        this.queries = in.readSerializableList(64, false, Hash::new);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

