/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.views;

import com.swirlds.common.constructable.ClassIdFormatter;
import com.swirlds.common.constructable.ConstructableRegistry;
import com.swirlds.common.crypto.CryptoFactory;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.internal.ExpectedLesson;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class StandardLearnerTreeView
implements LearnerTreeView<MerkleNode> {
    private final MerkleNode originalRoot;
    private final Queue<ExpectedLesson<MerkleNode>> expectedLessons;
    private final LinkedList<MerkleInternal> nodesToInitialize;

    public StandardLearnerTreeView(MerkleNode root) {
        this.originalRoot = root;
        this.expectedLessons = new LinkedList<ExpectedLesson<MerkleNode>>();
        this.nodesToInitialize = new LinkedList();
    }

    @Override
    public boolean isRootOfState() {
        return true;
    }

    @Override
    public MerkleNode getOriginalRoot() {
        return this.originalRoot;
    }

    @Override
    public boolean isInternal(MerkleNode node, boolean isOriginal) {
        return node != null && !node.isLeaf();
    }

    @Override
    public int getNumberOfChildren(MerkleNode node) {
        if (node == null || node.isLeaf()) {
            throw new MerkleSynchronizationException("only internal nodes have a child count");
        }
        return node.asInternal().getNumberOfChildren();
    }

    @Override
    public Hash getNodeHash(MerkleNode node) {
        if (node == null) {
            return CryptoFactory.getInstance().getNullHash();
        }
        return node.getHash();
    }

    @Override
    public long getClassId(MerkleNode node) {
        if (node == null) {
            throw new MerkleSynchronizationException("null does not have a class ID");
        }
        return node.getClassId();
    }

    @Override
    public MerkleNode convertMerkleRootToViewType(MerkleNode node) {
        return node;
    }

    @Override
    public MerkleNode getMerkleRoot(MerkleNode node) {
        return node;
    }

    @Override
    public MerkleNode getChild(MerkleNode parent, int childIndex) {
        if (parent == null || parent.isLeaf()) {
            throw new MerkleSynchronizationException("can not get child of leaf node");
        }
        return parent.asInternal().getChild(childIndex);
    }

    @Override
    public void setChild(MerkleNode parent, int childIndex, MerkleNode child) {
        parent.asInternal().setChild(childIndex, child);
    }

    @Override
    public void expectLessonFor(MerkleNode parent, int childIndex, MerkleNode original, boolean nodeAlreadyPresent) {
        this.expectedLessons.add(new ExpectedLesson<MerkleNode>(parent, childIndex, original, nodeAlreadyPresent));
    }

    @Override
    public ExpectedLesson<MerkleNode> getNextExpectedLesson() {
        return this.expectedLessons.remove();
    }

    @Override
    public boolean hasNextExpectedLesson() {
        return !this.expectedLessons.isEmpty();
    }

    @Override
    public MerkleNode deserializeLeaf(SerializableDataInputStream in) throws IOException {
        return (MerkleNode)in.readSerializable();
    }

    @Override
    public MerkleNode deserializeInternal(SerializableDataInputStream in) throws IOException {
        long classId = in.readLong();
        MerkleInternal internal = (MerkleInternal)ConstructableRegistry.createObject(classId);
        if (internal == null) {
            throw new MerkleSynchronizationException("unable to construct object with class ID " + ClassIdFormatter.classIdString(classId));
        }
        return internal;
    }

    @Override
    public void markForInitialization(MerkleNode node) {
        this.nodesToInitialize.add(node.asInternal());
    }

    @Override
    public void initialize() {
        Iterator<MerkleInternal> iterator = this.nodesToInitialize.descendingIterator();
        while (iterator.hasNext()) {
            iterator.next().initialize();
        }
    }

    @Override
    public void releaseNode(MerkleNode node) {
        if (node != null) {
            node.release();
        }
    }
}

