/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.utility;

import com.swirlds.common.MutabilityException;
import com.swirlds.common.ReferenceCountException;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.IllegalChildBoundsException;
import com.swirlds.common.merkle.exceptions.IllegalChildTypeException;
import com.swirlds.common.merkle.io.SerializationStrategy;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.utility.AbstractMerkleNode;
import com.swirlds.common.merkle.utility.MerkleUtils;
import java.util.List;
import java.util.Set;

public abstract class AbstractMerkleInternal
extends AbstractMerkleNode
implements MerkleInternal {
    private static final Set<SerializationStrategy> DEFAULT_STRATEGIES = Set.of(SerializationStrategy.DEFAULT_MERKLE_INTERNAL);

    protected AbstractMerkleInternal(boolean checkChildConstraints) {
        if (checkChildConstraints) {
            int version = this.getVersion();
            int min = this.getMinimumChildCount(version);
            int max = this.getMaximumChildCount(version);
            if (min < 0 || max < 1 || max < min || max > 64) {
                throw new IllegalChildBoundsException(0, 64);
            }
        }
    }

    protected AbstractMerkleInternal(AbstractMerkleInternal that) {
        super(that);
    }

    protected abstract void setChildInternal(int var1, MerkleNode var2);

    protected abstract void allocateSpaceForChild(int var1);

    protected abstract void checkChildIndexIsValid(int var1);

    @Override
    public final void setChild(int index, MerkleNode child, MerkleRoute childRoute, boolean childMayBeImmutable) {
        this.throwIfInvalidState();
        this.checkChildIndexIsValid(index);
        this.throwIfInvalidChild(index, child, childMayBeImmutable);
        this.allocateSpaceForChild(index);
        Object oldChild = this.getChild(index);
        if (oldChild == child) {
            return;
        }
        if (!this.isSelfHashing()) {
            this.invalidateHash();
        }
        if (oldChild != null) {
            oldChild.decrementReferenceCount();
        }
        if (child != null) {
            child.incrementReferenceCount();
            if (childRoute == null) {
                child.setRoute(this.computeRouteForChild(index));
            } else {
                child.setRoute(childRoute);
            }
        }
        this.setChildInternal(index, child);
    }

    private void throwIfInvalidChild(int index, MerkleNode child, boolean childMayBeImmutable) {
        long classId = Long.MIN_VALUE;
        if (child != null) {
            classId = child.getClassId();
            if (!childMayBeImmutable && child.isImmutable()) {
                throw new MutabilityException("Immutable child can not be added to parent. parent = " + MerkleUtils.merkleDebugString(this) + ", child = " + MerkleUtils.merkleDebugString(child));
            }
        }
        if (!this.childHasExpectedType(index, classId, this.getVersion())) {
            throw new IllegalChildTypeException(index, classId, this.getVersion(), this.getClassId());
        }
    }

    private void throwIfInvalidState() {
        if (this.isImmutable()) {
            throw new MutabilityException("Can not set child on immutable parent. " + MerkleUtils.merkleDebugString(this));
        }
        if (this.isReleased()) {
            throw new ReferenceCountException("Can not set child on released parent. " + MerkleUtils.merkleDebugString(this));
        }
    }

    private MerkleRoute computeRouteForChild(int index) {
        Object oldChild;
        MerkleRoute childRoute = null;
        if (this.getNumberOfChildren() > index && (oldChild = this.getChild(index)) != null) {
            childRoute = oldChild.getRoute();
        }
        if (childRoute == null) {
            childRoute = this.getRoute().extendRoute(index);
        }
        return childRoute;
    }

    @Override
    public void addDeserializedChildren(List<MerkleNode> children, int version) {
        for (int childIndex = 0; childIndex < children.size(); ++childIndex) {
            this.setChild(childIndex, children.get(childIndex));
        }
    }

    @Override
    protected void releaseInternal() {
        this.onRelease();
        for (int index = 0; index < this.getNumberOfChildren(); ++index) {
            Object child = this.getChild(index);
            if (child == null) continue;
            child.decrementReferenceCount();
        }
    }

    @Override
    public void invalidateHash() {
        this.setHash(null);
    }

    @Override
    public Set<SerializationStrategy> supportedSerialization(int version) {
        return DEFAULT_STRATEGIES;
    }

    @Override
    public final void setRoute(MerkleRoute route) {
        if (!this.getRoute().equals(route)) {
            super.setRoute(route);
            for (int index = 0; index < this.getNumberOfChildren(); ++index) {
                Object child = this.getChild(index);
                if (child == null) continue;
                child.setRoute(this.getRoute().extendRoute(index));
            }
        }
    }

    @Override
    public abstract AbstractMerkleInternal copy();
}

