/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.utility;

import com.swirlds.common.FastCopyable;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.io.SerializableDataOutputStream;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.common.merkle.utility.MerkleLong;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class KeyedMerkleLong<K extends FastCopyable & SelfSerializable>
extends MerkleLong
implements Keyed<K> {
    public static final long CLASS_ID = -2202809633841709934L;
    private static final int CLASS_VERSION = 1;
    private long value;
    private K key;

    public KeyedMerkleLong() {
    }

    public KeyedMerkleLong(long value) {
        this.value = value;
    }

    public KeyedMerkleLong(K key, long value) {
        this.value = value;
        this.key = key;
    }

    private KeyedMerkleLong(KeyedMerkleLong<K> that) {
        super(that);
        this.value = that.value;
        if (that.key != null) {
            this.key = that.key.copy();
        }
        that.setImmutable(true);
    }

    @Override
    public KeyedMerkleLong<K> copy() {
        this.throwIfImmutable();
        return new KeyedMerkleLong<K>(this);
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.value);
        out.writeSerializable((SelfSerializable)this.key, true);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.value = in.readLong();
        this.key = (FastCopyable)in.readSerializable();
    }

    @Override
    public long getClassId() {
        return -2202809633841709934L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("value", this.value).toString();
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public void setKey(K key) {
        this.key = key;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MerkleLong)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyedMerkleLong that = (KeyedMerkleLong)o;
        return this.value == that.value && Objects.equals(this.key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value, this.key);
    }
}

