/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.notification.internal;

import com.swirlds.common.futures.WaitingFuture;
import com.swirlds.common.notification.DispatchMode;
import com.swirlds.common.notification.DispatchOrder;
import com.swirlds.common.notification.Listener;
import com.swirlds.common.notification.NoListenersAvailableException;
import com.swirlds.common.notification.Notification;
import com.swirlds.common.notification.NotificationResult;
import com.swirlds.common.notification.internal.AbstractNotificationEngine;
import com.swirlds.common.notification.internal.Dispatcher;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class AsyncNotificationEngine
extends AbstractNotificationEngine {
    private Map<Class<? extends Listener>, Dispatcher<? extends Listener>> listenerRegistry = new ConcurrentHashMap<Class<? extends Listener>, Dispatcher<? extends Listener>>();

    public AsyncNotificationEngine() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    @Override
    public void initialize() {
    }

    @Override
    public void shutdown() {
        for (Dispatcher<? extends Listener> dispatcher : this.listenerRegistry.values()) {
            if (!dispatcher.isRunning()) continue;
            dispatcher.stop();
        }
    }

    @Override
    public <L extends Listener<N>, N extends Notification> Future<NotificationResult<N>> dispatch(Class<L> listenerClass, N notification) {
        this.checkArguments(listenerClass, (L)((Object)notification));
        DispatchOrder dispatchOrder = this.dispatchOrder(listenerClass);
        DispatchMode dispatchMode = this.dispatchMode(listenerClass);
        WaitingFuture future = new WaitingFuture();
        try {
            this.invokeWithDispatcher(dispatchOrder, listenerClass, dispatcher -> {
                this.assignSequence(notification);
                if (dispatchMode == DispatchMode.ASYNC) {
                    dispatcher.notifyAsync(notification, future::done);
                } else {
                    dispatcher.notifySync(notification, future::done);
                }
            });
        }
        catch (NoListenersAvailableException ex) {
            future.done(new NotificationResult<N>(notification, 0));
        }
        return future;
    }

    @Override
    public <L extends Listener> boolean register(Class<L> listenerClass, L callback) {
        this.checkArguments(listenerClass, callback);
        Dispatcher<L> dispatcher = this.ensureDispatcherExists(listenerClass);
        return dispatcher.addListener(callback);
    }

    @Override
    public <L extends Listener> boolean unregister(Class<L> listenerClass, L callback) {
        this.checkArguments(listenerClass, callback);
        Dispatcher<L> dispatcher = this.ensureDispatcherExists(listenerClass);
        return dispatcher.removeListener(callback);
    }

    private <L extends Listener<N>, N extends Notification> void checkArguments(Class<L> listenerClass, N notification) {
        if (listenerClass == null) {
            throw new IllegalArgumentException("listenerClass");
        }
        if (notification == null) {
            throw new IllegalArgumentException("notification");
        }
    }

    private <L extends Listener> void checkArguments(Class<L> listenerClass, L callback) {
        if (listenerClass == null) {
            throw new IllegalArgumentException("listenerClass");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
    }

    private <L extends Listener> Dispatcher<L> ensureDispatcherExists(Class<L> listenerClass) {
        Dispatcher<L> dispatcher = this.listenerRegistry.putIfAbsent(listenerClass, new Dispatcher<L>(listenerClass));
        if (dispatcher == null) {
            dispatcher = new Dispatcher<L>(listenerClass);
            this.listenerRegistry.put(listenerClass, dispatcher);
        }
        return dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <L extends Listener<N>, N extends Notification> void invokeWithDispatcher(DispatchOrder order, Class<L> listenerClass, Consumer<Dispatcher<L>> method) throws NoListenersAvailableException {
        Dispatcher<? extends Listener> dispatcher = this.listenerRegistry.get(listenerClass);
        if (dispatcher == null) {
            throw new NoListenersAvailableException();
        }
        if (order == DispatchOrder.ORDERED) {
            Object object = dispatcher.getMutex();
            synchronized (object) {
                method.accept(dispatcher);
            }
        } else {
            method.accept(dispatcher);
        }
    }
}

