/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.statistics.internal;

import com.swirlds.common.CommonUtils;
import com.swirlds.common.internal.SettingsCommon;
import com.swirlds.common.statistics.StatEntry;
import com.swirlds.common.statistics.Statistics;
import com.swirlds.common.statistics.StatsBuffered;
import com.swirlds.common.statistics.internal.StatsBuffer;
import com.swirlds.logging.LogMarker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class AbstractStatistics
implements Statistics {
    private static final Logger log = LogManager.getLogger(AbstractStatistics.class);
    private static final Marker ERROR = MarkerManager.getMarker((String)"EXCEPTION");
    public static final String INFO_CATEGORY = "platform.info";
    public static final String CATEGORY = "platform";
    public static final String PING_CATEGORY = "ping";
    public static final String BPSS_CATEGORY = "bpss";
    public static final String INTERNAL_CATEGORY = "internal";
    public static final String DATABASE_CATEGORY = "database";
    protected static boolean printStats = false;
    protected int statsWritePeriod = 3000;
    protected Map<Integer, StatEntry> index2entry = new HashMap<Integer, StatEntry>();
    protected Map<StatEntry, Integer> entry2index = new HashMap<StatEntry, Integer>();
    protected Map<String, StatEntry> name2entry = new HashMap<String, StatEntry>();
    private String[][] allStatEntries;
    protected StatEntry[] statEntries = this.getStatEntriesArray();
    private static final int STATS_EXPAND_WIDTH = 4;
    private static final String EXCLUDE_CATEGORY = "info";
    private int expandableCount;

    protected AbstractStatistics() {
        this.setUpStatEntries();
    }

    protected void setUpStatEntries() {
        if (this.statEntries != null) {
            for (StatEntry stat : this.statEntries) {
                if (stat.init == null) continue;
                stat.buffered = stat.init.apply(SettingsCommon.halfLife);
            }
            this.initStatEntries(SettingsCommon.showInternalStats);
            if (printStats) {
                printStats = false;
                this.printAvailableStats();
            }
        }
    }

    public void resetAllSpeedometers() {
        for (StatEntry stat : this.statEntries) {
            if (stat.reset != null) {
                stat.reset.accept(SettingsCommon.halfLife);
                continue;
            }
            if (stat.buffered == null) continue;
            stat.buffered.reset(SettingsCommon.halfLife);
        }
    }

    @Override
    public void setStatsWritePeriod(int writePeriod) {
        this.statsWritePeriod = writePeriod;
    }

    @Override
    public String[][] getAvailableStats() {
        return this.allStatEntries;
    }

    @Override
    public int getNumStats() {
        return this.getAvailableStats().length;
    }

    @Override
    public double getStat(String statName) {
        StatEntry stat = this.name2entry.get(statName);
        if (stat == null) {
            return -1.0;
        }
        Object s = stat.statsStringSupplier.get();
        if (s instanceof Number) {
            return (Double)s;
        }
        return -1.0;
    }

    @Override
    public double getStat(int index) {
        StatEntry stat = this.index2entry.get(index);
        if (stat == null) {
            return -1.0;
        }
        Object s = stat.statsStringSupplier.get();
        if (s instanceof Number) {
            return (Double)s;
        }
        return -1.0;
    }

    public StatsBuffer getAllHistory(String statName) {
        StatEntry stat = this.name2entry.get(statName);
        if (stat == null) {
            return null;
        }
        StatsBuffered buf = stat.buffered;
        if (buf == null) {
            return null;
        }
        return buf.getAllHistory();
    }

    public StatsBuffer getRecentHistory(String statName) {
        StatEntry stat = this.name2entry.get(statName);
        if (stat == null) {
            return null;
        }
        StatsBuffered buf = stat.buffered;
        if (buf == null) {
            return null;
        }
        return buf.getRecentHistory();
    }

    public StatsBuffer getAllHistory(int index) {
        StatEntry stat = this.index2entry.get(index);
        if (stat == null) {
            return null;
        }
        StatsBuffered buf = stat.buffered;
        if (buf == null) {
            return null;
        }
        return buf.getAllHistory();
    }

    public StatsBuffer getRecentHistory(int index) {
        StatEntry stat = this.index2entry.get(index);
        if (stat == null) {
            return null;
        }
        StatsBuffered buf = stat.buffered;
        if (buf == null) {
            return null;
        }
        return buf.getRecentHistory();
    }

    @Override
    public String getStatString(String statName) {
        StatEntry stat = this.name2entry.get(statName);
        if (stat == null) {
            return "";
        }
        return AbstractStatistics.getStatString(stat);
    }

    @Override
    public int getStatIndex(String statName) {
        StatEntry stat = this.name2entry.get(statName);
        if (stat == null) {
            return -1;
        }
        Integer index = this.entry2index.get(stat);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public String getStatString(int index, boolean reset) {
        StatEntry stat = this.index2entry.get(index);
        try {
            if (stat == null) {
                return "";
            }
            Supplier<Object> supplier = reset ? stat.resetStatsStringSupplier : stat.statsStringSupplier;
            return String.format(Locale.US, stat.format, supplier.get());
        }
        catch (IllegalFormatException e) {
            log.error(LogMarker.EXCEPTION.getMarker(), "unable to compute string for {}", (Object)stat.name, (Object)e);
            return "";
        }
    }

    @Override
    public String getStatString(int index) {
        return this.getStatString(index, false);
    }

    public String getMinString(int index) {
        try {
            StatEntry stat = this.index2entry.get(index);
            if (stat == null || stat.buffered == null) {
                return "";
            }
            return String.format(Locale.US, stat.format, stat.buffered.getMin());
        }
        catch (IllegalFormatException e) {
            log.error(ERROR, "", (Throwable)e);
            return "";
        }
    }

    public String getMaxString(int index) {
        try {
            StatEntry stat = this.index2entry.get(index);
            if (stat == null || stat.buffered == null) {
                return "";
            }
            return String.format(Locale.US, stat.format, stat.buffered.getMax());
        }
        catch (IllegalFormatException e) {
            log.error(ERROR, "", (Throwable)e);
            return "";
        }
    }

    public String getStdDevString(int index) {
        try {
            StatEntry stat = this.index2entry.get(index);
            if (stat == null || stat.buffered == null) {
                return "";
            }
            return String.format(Locale.US, stat.format, stat.buffered.getStdDev());
        }
        catch (IllegalFormatException e) {
            log.error(ERROR, "", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getStatCategory(int index) {
        StatEntry stat = this.index2entry.get(index);
        if (stat == null) {
            return "";
        }
        return stat.category;
    }

    @Override
    public String getName(int index) {
        StatEntry stat = this.index2entry.get(index);
        if (stat == null) {
            return "";
        }
        return stat.name;
    }

    private static String getStatString(StatEntry stat) {
        try {
            return String.format(Locale.US, stat.format, stat.statsStringSupplier.get());
        }
        catch (IllegalFormatException e) {
            log.error(ERROR, "", (Throwable)e);
            return "";
        }
    }

    public void printAvailableStats() {
        CommonUtils.tellUserConsole("* <ul>");
        for (int i = 0; i < this.statEntries.length; ++i) {
            CommonUtils.tellUserConsole("* <li><b>" + this.statEntries[i].name + "</b> - " + this.statEntries[i].desc);
        }
        CommonUtils.tellUserConsole("* </ul>");
    }

    public void initStatEntries(boolean includeInternal) {
        int i;
        ArrayList<StatEntry> toShow = new ArrayList<StatEntry>();
        Arrays.sort(this.statEntries, (a, b) -> a.name.toLowerCase().compareTo(b.name.toLowerCase()));
        int index = 0;
        for (i = 0; i < this.statEntries.length; ++i) {
            String category = this.statEntries[i].category;
            if (!includeInternal && category.equals(INTERNAL_CATEGORY)) continue;
            toShow.add(this.statEntries[i]);
            this.name2entry.put(this.statEntries[i].name, this.statEntries[i]);
            this.index2entry.put(index, this.statEntries[i]);
            this.entry2index.put(this.statEntries[i], index);
            ++index;
        }
        this.allStatEntries = new String[toShow.size()][3];
        for (i = 0; i < toShow.size(); ++i) {
            StatEntry stat = (StatEntry)toShow.get(i);
            this.allStatEntries[i][0] = stat.name;
            this.allStatEntries[i][1] = stat.desc;
            this.allStatEntries[i][2] = stat.format;
        }
        this.expandableCount = (int)Arrays.stream(this.statEntries).filter(f -> !f.category.contains(EXCLUDE_CATEGORY)).count();
    }

    public abstract void updateOthers();

    public abstract StatEntry[] getStatEntriesArray();

    private String[] getStringArray() {
        if (this.allStatEntries == null || this.allStatEntries.length == 0) {
            return new String[0];
        }
        return SettingsCommon.verboseStatistics ? new String[this.expandableCount * 4 + this.allStatEntries.length - this.expandableCount] : new String[this.allStatEntries.length];
    }

    public String[] getCategoryStrings() {
        String[] result = this.getStringArray();
        if (this.allStatEntries != null && this.name2entry != null) {
            int stringCount = 0;
            for (int index = 0; index < this.allStatEntries.length; ++index) {
                StatEntry entry = this.name2entry.get(this.allStatEntries[index][0]);
                String category = entry.category;
                if (SettingsCommon.verboseStatistics && !category.contains(EXCLUDE_CATEGORY)) {
                    for (int repeat = 0; repeat < 4; ++repeat) {
                        result[stringCount] = entry.category;
                        ++stringCount;
                    }
                    continue;
                }
                result[stringCount] = entry.category;
                ++stringCount;
            }
        }
        return result;
    }

    public String[] getNameStrings(boolean allowExpand) {
        String[] result = allowExpand ? this.getStringArray() : (this.allStatEntries != null ? new String[this.allStatEntries.length] : new String[]{});
        if (this.allStatEntries != null && this.name2entry != null) {
            int stringCount = 0;
            for (int index = 0; index < this.allStatEntries.length; ++index) {
                StatEntry entry = this.name2entry.get(this.allStatEntries[index][0]);
                String category = entry.category;
                if (allowExpand && SettingsCommon.verboseStatistics && !category.contains(EXCLUDE_CATEGORY)) {
                    result[stringCount] = entry.name;
                    result[++stringCount] = entry.name + "Max";
                    result[++stringCount] = entry.name + "Min";
                    result[++stringCount] = entry.name + "Std";
                    ++stringCount;
                    continue;
                }
                result[stringCount] = entry.name;
                ++stringCount;
            }
        }
        return result;
    }

    public String[] getResetValueStrings() {
        String[] result = this.getStringArray();
        if (this.allStatEntries != null && this.name2entry != null) {
            int stringCount = 0;
            for (int index = 0; index < this.allStatEntries.length; ++index) {
                StatEntry entry = this.name2entry.get(this.allStatEntries[index][0]);
                String category = entry.category;
                if (SettingsCommon.verboseStatistics && !category.contains(EXCLUDE_CATEGORY)) {
                    result[stringCount] = this.getStatString(index);
                    result[++stringCount] = this.getMaxString(index);
                    result[++stringCount] = this.getMinString(index);
                    result[++stringCount] = this.getStdDevString(index);
                    ++stringCount;
                    continue;
                }
                result[stringCount] = this.getStatString(index, true);
                ++stringCount;
            }
        }
        return result;
    }

    public String[] getDescriptionStrings() {
        String[] result;
        String[] stringArray = result = this.statEntries != null ? new String[this.statEntries.length] : new String[]{};
        if (this.statEntries != null) {
            for (int index = 0; index < this.statEntries.length; ++index) {
                StatEntry entry = this.statEntries[index];
                result[index] = entry.desc;
            }
        }
        return result;
    }
}

