/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream;

import com.swirlds.common.crypto.CryptoFactory;
import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.SerializableHashable;
import com.swirlds.common.crypto.SerializableRunningHashable;
import com.swirlds.common.stream.AbstractLinkedObjectStream;
import com.swirlds.common.stream.LinkedObjectStream;
import com.swirlds.logging.LogMarker;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HashCalculatorForStream<T extends SerializableRunningHashable>
extends AbstractLinkedObjectStream<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Cryptography cryptography;

    public HashCalculatorForStream() {
        this.cryptography = CryptoFactory.getInstance();
    }

    public HashCalculatorForStream(LinkedObjectStream<T> nextStream) {
        super(nextStream);
        this.cryptography = CryptoFactory.getInstance();
    }

    public HashCalculatorForStream(LinkedObjectStream<T> nextStream, Cryptography cryptography) {
        super(nextStream);
        this.cryptography = Objects.requireNonNull(cryptography);
    }

    public HashCalculatorForStream(Cryptography cryptography) {
        this.cryptography = Objects.requireNonNull(cryptography);
    }

    @Override
    public void addObject(T t) {
        if (((SerializableRunningHashable)Objects.requireNonNull(t)).getHash() == null) {
            this.cryptography.digestSync((SerializableHashable)t);
        }
        super.addObject(t);
    }

    @Override
    public void close() {
        super.close();
        LOGGER.info(LogMarker.OBJECT_STREAM.getMarker(), "HashCalculatorForStream is closed");
    }
}

