/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream;

import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.HashingOutputStream;
import com.swirlds.common.crypto.RunningHash;
import com.swirlds.common.crypto.RunningHashable;
import com.swirlds.common.crypto.SerializableRunningHashable;
import com.swirlds.common.crypto.Signature;
import com.swirlds.common.crypto.SignatureType;
import com.swirlds.common.futures.WaitingFuture;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDataOutputStream;
import com.swirlds.common.stream.LinkedObjectStream;
import com.swirlds.common.stream.LinkedObjectStreamUtilities;
import com.swirlds.common.stream.Signer;
import com.swirlds.common.stream.StreamType;
import com.swirlds.common.stream.Timestamped;
import com.swirlds.logging.LogMarker;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class TimestampStreamFileWriter<T extends Timestamped & SerializableRunningHashable>
implements LinkedObjectStream<T> {
    private static final Logger log = LogManager.getLogger();
    public static final int OBJECT_STREAM_VERSION = 1;
    public static final int OBJECT_STREAM_SIG_VERSION = 1;
    private final StreamType streamType;
    private FileOutputStream stream = null;
    private SerializableDataOutputStream dos = null;
    private SerializableDataOutputStream dosMeta = null;
    private String fileNameShort;
    private File file;
    private String dirPath;
    private RunningHash runningHash;
    private Signer signer;
    private long logPeriodMs;
    private Instant lastConsensusTimestamp;
    private boolean startWriteAtCompleteWindow;
    private static final SignatureType signatureType = SignatureType.RSA;
    private MessageDigest mdEntire;
    private MessageDigest mdMeta;

    public TimestampStreamFileWriter(String dirPath, long logPeriodMs, Signer signer, boolean startWriteAtCompleteWindow, StreamType streamType) throws NoSuchAlgorithmException {
        this.dirPath = dirPath;
        this.logPeriodMs = logPeriodMs;
        this.signer = signer;
        this.startWriteAtCompleteWindow = startWriteAtCompleteWindow;
        this.streamType = streamType;
        this.mdEntire = MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
        this.mdMeta = MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
    }

    private void consume(T object) {
        try {
            this.dos.writeSerializable((SelfSerializable)object, true);
            this.dos.flush();
        }
        catch (IOException e) {
            log.warn(LogMarker.EXCEPTION.getMarker(), "IOException when serializing {}", object, (Object)e);
        }
    }

    private void startNewFile(T object) {
        this.file = new File(this.generateStreamFilePath(object));
        this.fileNameShort = this.file.getName();
        try {
            if (this.file.exists() && !this.file.isDirectory()) {
                log.info(LogMarker.OBJECT_STREAM.getMarker(), "Stream file already exists {}", (Object)this.fileNameShort);
            } else {
                this.stream = new FileOutputStream(this.file, false);
                this.dos = new SerializableDataOutputStream(new BufferedOutputStream(new HashingOutputStream(this.mdEntire, this.stream)));
                this.dosMeta = new SerializableDataOutputStream(new HashingOutputStream(this.mdMeta));
                log.info(LogMarker.OBJECT_STREAM_FILE.getMarker(), "Stream file created {}", (Object)this.fileNameShort);
            }
        }
        catch (FileNotFoundException e) {
            log.error(LogMarker.EXCEPTION.getMarker(), "startNewFile :: FileNotFound: ", (Throwable)e);
        }
    }

    private void begin() {
        try {
            for (int num : this.streamType.getFileHeader()) {
                this.dos.writeInt(num);
                this.dosMeta.writeInt(num);
            }
            this.dos.writeInt(1);
            this.dosMeta.writeInt(1);
            log.info(LogMarker.OBJECT_STREAM_FILE.getMarker(), "begin :: write OBJECT_STREAM_VERSION {}", (Object)1);
            Hash startRunningHash = (Hash)((WaitingFuture)this.runningHash.getFutureHash()).get();
            this.dos.writeSerializable(startRunningHash, true);
            this.dosMeta.writeSerializable(startRunningHash, true);
            log.info(LogMarker.OBJECT_STREAM_FILE.getMarker(), "begin :: write startRunningHash {}", (Object)startRunningHash);
        }
        catch (IOException e) {
            Thread.currentThread().interrupt();
            log.error(LogMarker.EXCEPTION.getMarker(), "begin :: Got IOException when writing startRunningHash to {}", (Object)this.fileNameShort, (Object)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error(LogMarker.EXCEPTION.getMarker(), "begin :: Got interrupted when getting startRunningHash for writing {}", (Object)this.fileNameShort, (Object)e);
        }
    }

    public void closeCurrentAndSign() {
        if (this.stream != null) {
            try {
                Hash endRunningHash = (Hash)((WaitingFuture)this.runningHash.getFutureHash()).get();
                this.dos.writeSerializable(endRunningHash, true);
                this.dosMeta.writeSerializable(endRunningHash, true);
                log.info(LogMarker.OBJECT_STREAM_FILE.getMarker(), "closeCurrentAndSign :: write endRunningHash {}", (Object)endRunningHash);
            }
            catch (IOException e) {
                Thread.currentThread().interrupt();
                log.error(LogMarker.EXCEPTION.getMarker(), "closeCurrentAndSign :: Got Exception when writing endRunningHash to {}", (Object)this.fileNameShort, (Object)e);
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error(LogMarker.EXCEPTION.getMarker(), "closeCurrentAndSign :: Got interrupted when getting endRunningHash for writing {}", (Object)this.fileNameShort, (Object)e);
                return;
            }
            File currentFile = this.file;
            this.closeFile();
            Hash entireHash = new Hash(this.mdEntire.digest(), DigestType.SHA_384);
            Hash metaHash = new Hash(this.mdMeta.digest(), DigestType.SHA_384);
            Signature entireSignature = new Signature(signatureType, this.signer.sign(entireHash.getValue()));
            Signature metaSignature = new Signature(signatureType, this.signer.sign(metaHash.getValue()));
            try {
                TimestampStreamFileWriter.writeSignatureFile(entireHash, entireSignature, metaHash, metaSignature, LinkedObjectStreamUtilities.generateSigFilePath(currentFile), this.streamType);
            }
            catch (IOException e) {
                log.error(LogMarker.EXCEPTION.getMarker(), "closeCurrentAndSign ::  :: Fail to generate signature file for {}", (Object)this.fileNameShort, (Object)e);
            }
        }
    }

    public static void writeSignatureFile(Hash entireHash, Signature entireSignature, Hash metaHash, Signature metaSignature, String sigFilePath, StreamType streamType) throws IOException {
        try (SerializableDataOutputStream output = new SerializableDataOutputStream(new BufferedOutputStream(new FileOutputStream(sigFilePath)));){
            for (byte num : streamType.getSigFileHeader()) {
                output.writeByte(num);
            }
            output.writeInt(1);
            output.writeSerializable(entireHash, true);
            output.writeSerializable(entireSignature, true);
            output.writeSerializable(metaHash, true);
            output.writeSerializable(metaSignature, true);
            log.info(LogMarker.OBJECT_STREAM_FILE.getMarker(), "signature file saved: {}", (Object)sigFilePath);
        }
    }

    private void closeFile() {
        if (this.stream != null) {
            try {
                this.dos.flush();
                this.stream.flush();
                this.stream.getChannel().force(true);
                this.stream.getFD().sync();
                this.dos.close();
                this.stream.close();
                this.dosMeta.close();
                this.file = null;
                this.stream = null;
                this.dos = null;
                this.dosMeta = null;
            }
            catch (IOException e) {
                log.warn(LogMarker.EXCEPTION.getMarker(), "Exception in close file", (Throwable)e);
            }
            log.info(LogMarker.OBJECT_STREAM_FILE.getMarker(), "File {} is closed at {}", new Supplier[]{() -> this.fileNameShort, () -> Instant.now()});
        }
    }

    public boolean checkIfShouldWriteNewFile(T object) {
        Instant currentConsensusTimestamp = object.getTimestamp();
        boolean result = this.lastConsensusTimestamp == null && !this.startWriteAtCompleteWindow ? true : (this.lastConsensusTimestamp == null && this.startWriteAtCompleteWindow ? false : LinkedObjectStreamUtilities.getPeriod(this.lastConsensusTimestamp, this.logPeriodMs) != LinkedObjectStreamUtilities.getPeriod(currentConsensusTimestamp, this.logPeriodMs));
        this.lastConsensusTimestamp = currentConsensusTimestamp;
        return result;
    }

    String generateStreamFilePath(T object) {
        return this.dirPath + File.separator + LinkedObjectStreamUtilities.generateStreamFileNameFromInstant(object.getTimestamp(), this.streamType);
    }

    @Override
    public void setRunningHash(Hash hash) {
        this.runningHash = new RunningHash(hash);
    }

    @Override
    public void addObject(T object) {
        if (this.checkIfShouldWriteNewFile(object)) {
            this.closeCurrentAndSign();
            this.startNewFile(object);
            if (this.stream != null) {
                this.begin();
            }
        }
        if (this.stream != null) {
            this.consume(object);
        }
        this.runningHash = ((RunningHashable)object).getRunningHash();
    }

    @Override
    public void clear() {
        if (this.stream != null) {
            File currentFile = this.file;
            this.closeFile();
            try {
                Files.delete(currentFile.toPath());
                log.info(LogMarker.OBJECT_STREAM.getMarker(), "TimestampStreamFileWriter::clear deleted {}", new Supplier[]{() -> currentFile.getName()});
            }
            catch (IOException ex) {
                log.error(LogMarker.EXCEPTION.getMarker(), "TimestampStreamFileWriter::clear got IOException when deleting file {}", new Supplier[]{() -> currentFile.getName()});
            }
        }
    }

    @Override
    public void close() {
        this.closeCurrentAndSign();
        log.info(LogMarker.FREEZE.getMarker(), "TimestampStreamFileWriter finished writing the last object, is stopped");
    }

    public void setStartWriteAtCompleteWindow(boolean startWriteAtCompleteWindow) {
        this.startWriteAtCompleteWindow = startWriteAtCompleteWindow;
        log.info(LogMarker.OBJECT_STREAM.getMarker(), "TimestampStreamFileWriter::setStartWriteAtCompleteWindow: {}", (Object)startWriteAtCompleteWindow);
    }

    public boolean getStartWriteAtCompleteWindow() {
        return this.startWriteAtCompleteWindow;
    }
}

