/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.testutils;

import com.swirlds.common.SwirldTransaction;
import com.swirlds.common.Transaction;
import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.events.BaseEventHashedData;
import com.swirlds.common.events.BaseEventUnhashedData;
import com.swirlds.common.events.ConsensusData;
import com.swirlds.common.transaction.internal.StateSignatureTransaction;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class DetGenerateUtils {
    private static final DigestType DEFAULT_HASH_TYPE = DigestType.SHA_384;
    private static final long DEFAULT_MAX_EPOCH = 1583243881L;
    private static final int DEFAULT_TRANSACTION_NUMBER = 10;
    private static final int DEFAULT_TRANSACTION_MAX_SIZE = 100;
    private static final int DEFAULT_SIGNATURE_SIZE = 384;
    private static final int DEFAULT_ROUND_MAX_DIFF = 10;

    public static BaseEventHashedData generateBaseEventHashedData(Random random) {
        return new BaseEventHashedData(DetGenerateUtils.nextLong(random, 0L), DetGenerateUtils.nextLong(random, 0L), DetGenerateUtils.nextLong(random, 0L), DetGenerateUtils.generateRandomHash(random, DEFAULT_HASH_TYPE), DetGenerateUtils.generateRandomHash(random, DEFAULT_HASH_TYPE), DetGenerateUtils.generateRandomInstant(random, 1583243881L), DetGenerateUtils.generateTransactions(10, 100, random).toArray(new Transaction[0]));
    }

    public static BaseEventUnhashedData generateBaseEventUnhashedData(Random random) {
        return new BaseEventUnhashedData(DetGenerateUtils.nextLong(random, 0L), DetGenerateUtils.generateRandomByteArray(random, 384));
    }

    public static ConsensusData generateConsensusEventData(Random random) {
        ConsensusData data = new ConsensusData();
        data.setRoundCreated(DetGenerateUtils.nextLong(random, 0L));
        random.nextBoolean();
        random.nextBoolean();
        data.setStale(random.nextBoolean());
        data.setConsensusTimestamp(DetGenerateUtils.generateRandomInstant(random, 1583243881L));
        data.setRoundReceived(DetGenerateUtils.nextLong(random, data.getRoundCreated() + 1L, data.getRoundCreated() + 10L));
        data.setConsensusOrder(DetGenerateUtils.nextLong(random, 0L));
        return data;
    }

    public static List<Transaction> generateTransactions(int number, int maxSize, Random random) {
        ArrayList<Transaction> list = new ArrayList<Transaction>(number);
        for (int i = 0; i < number; ++i) {
            int size = Math.max(1, random.nextInt(maxSize));
            byte[] bytes = new byte[size];
            random.nextBytes(bytes);
            boolean system = random.nextBoolean();
            if (system) {
                byte[] sigature = new byte[384];
                random.nextBytes(sigature);
                list.add(new StateSignatureTransaction(random.nextBoolean(), random.nextLong(), sigature));
                continue;
            }
            list.add(new SwirldTransaction(bytes));
        }
        return list;
    }

    public static Hash generateRandomHash(Random random, DigestType type) {
        return new Hash(DetGenerateUtils.generateRandomByteArray(random, type.digestLength()), type);
    }

    public static Instant generateRandomInstant(Random random, long maxEpoch) {
        return Instant.ofEpochSecond(DetGenerateUtils.nextLong(random, 0L, maxEpoch - 1L), DetGenerateUtils.nextLong(random, 0L, 1000000000L));
    }

    public static long nextLong(Random random, long min) {
        return DetGenerateUtils.nextLong(random, min, Long.MAX_VALUE);
    }

    public static long nextLong(Random random, long min, long max) {
        return random.longs(1L, min, max).findFirst().orElseThrow();
    }

    public static byte[] generateRandomByteArray(Random random, int size) {
        byte[] bytes = new byte[size];
        random.nextBytes(bytes);
        return bytes;
    }
}

