/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading;

import com.swirlds.common.threading.InterruptableRunnable;
import com.swirlds.common.threading.QueueThreadConfiguration;
import com.swirlds.common.threading.QueueThreadHandler;
import com.swirlds.common.threading.QueueThreadThreshold;
import com.swirlds.common.threading.StoppableThread;
import com.swirlds.logging.LogMarker;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueueThread<T>
implements BlockingQueue<T>,
StoppableThread {
    private static final Logger log = LogManager.getLogger();
    private static final int WAIT_FOR_WORK_DELAY_MS = 10;
    protected final BlockingQueue<T> queue;
    private final int bufferSize;
    private final List<T> buffer;
    private final List<QueueThreadThreshold> thresholds;
    private final QueueThreadHandler<T> handler;
    private final StoppableThread stoppableThread;
    private final InterruptableRunnable waitForItemRunnable;

    protected QueueThread(QueueThreadConfiguration<T> configuration) {
        int capacity = configuration.getCapacity();
        this.queue = configuration.getQueue() != null ? configuration.getQueue() : (capacity > 0 ? new LinkedBlockingQueue<T>(capacity) : new LinkedBlockingQueue<T>());
        this.bufferSize = capacity > 0 ? Math.min(capacity, configuration.getMaxBufferSize()) : configuration.getMaxBufferSize();
        this.thresholds = new LinkedList<QueueThreadThreshold>(configuration.getThresholds());
        this.buffer = new ArrayList<T>(this.bufferSize);
        this.handler = configuration.getHandler();
        this.waitForItemRunnable = Objects.requireNonNullElseGet(configuration.getWaitForItemRunnable(), () -> this::waitForItem);
        this.stoppableThread = configuration.getStoppableThreadConfiguration().setWork(this::doWork).setInterruptable(configuration.isInterruptable()).setFinalCycleWork(this::doFinalCycleWork).build();
    }

    @Override
    public void start() {
        this.stoppableThread.start();
    }

    @Override
    public void pause() throws InterruptedException {
        this.stoppableThread.pause();
    }

    @Override
    public void resume() {
        this.stoppableThread.resume();
    }

    @Override
    public void join() throws InterruptedException {
        this.stoppableThread.join();
    }

    @Override
    public void join(long millis) throws InterruptedException {
        this.stoppableThread.join(millis);
    }

    @Override
    public void join(long millis, int nanos) throws InterruptedException {
        this.stoppableThread.join(millis, nanos);
    }

    @Override
    public void stop() {
        this.stoppableThread.stop();
    }

    @Override
    public void interrupt() {
        this.stoppableThread.interrupt();
    }

    @Override
    public boolean isAlive() {
        return this.stoppableThread.isAlive();
    }

    @Override
    public boolean isHanging() {
        return this.stoppableThread.isHanging();
    }

    private void checkThresholds() {
        if (this.thresholds.size() > 0) {
            int size = this.queue.size();
            Instant now = Instant.now();
            for (QueueThreadThreshold threshold : this.thresholds) {
                threshold.checkValue(now, size);
            }
        }
    }

    private void doWork() throws InterruptedException {
        this.checkThresholds();
        this.queue.drainTo(this.buffer, this.bufferSize);
        if (this.buffer.size() == 0) {
            this.waitForItemRunnable.run();
            return;
        }
        for (T item : this.buffer) {
            this.handler.handle(item);
        }
        this.buffer.clear();
    }

    private void waitForItem() throws InterruptedException {
        T item = this.queue.poll(10L, TimeUnit.MILLISECONDS);
        if (item != null) {
            this.handler.handle(item);
        }
    }

    private void doFinalCycleWork() throws InterruptedException {
        while (this.queue.size() > 0) {
            this.queue.drainTo(this.buffer, this.bufferSize);
            for (T item : this.buffer) {
                this.handler.handle(item);
            }
        }
    }

    @Override
    public boolean add(T t) {
        return this.queue.add(t);
    }

    @Override
    public boolean offer(T t) {
        return this.queue.offer(t);
    }

    @Override
    public T remove() {
        return (T)this.queue.remove();
    }

    @Override
    public T poll() {
        return (T)this.queue.poll();
    }

    @Override
    public T element() {
        return (T)this.queue.element();
    }

    @Override
    public T peek() {
        return (T)this.queue.peek();
    }

    @Override
    public void put(T t) throws InterruptedException {
        this.queue.put(t);
    }

    @Override
    public boolean offer(T t, long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.offer(t, timeout, unit);
    }

    @Override
    public T take() throws InterruptedException {
        return this.queue.take();
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.poll(timeout, unit);
    }

    @Override
    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.queue.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.queue.retainAll(c);
    }

    @Override
    public void clear() {
        if (!this.isAlive()) {
            this.queue.clear();
            return;
        }
        try {
            this.pause();
        }
        catch (InterruptedException e) {
            log.error(LogMarker.ERROR.getMarker(), "interrupted while attempting to clear queue thread {}", (Object)this.stoppableThread.getName());
            Thread.currentThread().interrupt();
            return;
        }
        this.queue.clear();
        this.resume();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        return this.queue.drainTo(c);
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        return this.queue.drainTo(c, maxElements);
    }

    @Override
    public String getName() {
        return this.stoppableThread.getName();
    }
}

